/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseAtomicHashMapAPITest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configurationBuilder = BaseAtomicHashMapAPITest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(100L);
        this.createClusteredCaches(2, "atomic", configurationBuilder);
    }

    public void testMultipleTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        TransactionManager tm1 = this.tm(cache1);
        Map<String, String> map1 = this.createAtomicMap(cache1, "testMultipleTx", true);
        Map map2 = this.createAtomicMap(cache2, "testMultipleTx", false);
        Map<Object, Object> expectedMap = Collections.emptyMap();
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
        tm1.begin();
        map1.put("k1", "initial");
        tm1.commit();
        expectedMap = this.createMap("k1", "initial");
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
        tm1.begin();
        map1.put("k1", "v1");
        map1.put("k2", "v2");
        map1.put("k3", "v3");
        tm1.commit();
        expectedMap = this.createMap("k1", "v1", "k2", "v2", "k3", "v3");
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
        tm1.begin();
        map1.put("k4", "v4");
        map1.put("k5", "v5");
        map1.put("k6", "v6");
        tm1.commit();
        expectedMap = this.createMap("k1", "v1", "k2", "v2", "k3", "v3", "k4", "v4", "k5", "v5", "k6", "v6");
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
    }

    public void testSizeOnCache() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        TransactionManager tm1 = this.tm(0, "atomic");
        this.assertSize((Map<?, ?>)cache1, 0);
        cache1.put((Object)new MagicKey("Hi", cache1), (Object)"Someone");
        this.assertSize((Map<?, ?>)cache1, 1);
        tm1.begin();
        this.assertSize((Map<?, ?>)cache1, 1);
        cache1.put((Object)new MagicKey("Need", cache1), (Object)"Read Consistency");
        this.assertSize((Map<?, ?>)cache1, 2);
        tm1.commit();
        this.assertSize((Map<?, ?>)cache1, 2);
        tm1.begin();
        this.assertSize((Map<?, ?>)cache1, 2);
        cache1.put((Object)new MagicKey("Need Also", cache1), (Object)"Speed");
        this.assertSize((Map<?, ?>)cache1, 3);
        tm1.rollback();
        this.assertSize((Map<?, ?>)cache1, 2);
        Map<String, String> atomicMap = this.createAtomicMap(cache1, new MagicKey("testSizeOnCache", cache1), true);
        this.assertSize((Map<?, ?>)cache1, 3);
        atomicMap.put("mm", "nn");
        this.assertSize((Map<?, ?>)cache1, 3);
        tm1.begin();
        this.assertSize((Map<?, ?>)cache1, 3);
        atomicMap = this.createAtomicMap(cache1, new MagicKey("testSizeOnCache-second", cache1), true);
        this.assertSize((Map<?, ?>)cache1, 4);
        atomicMap.put("mm", "nn");
        this.assertSize((Map<?, ?>)cache1, 4);
        tm1.commit();
        this.assertSize((Map<?, ?>)cache1, 4);
        tm1.begin();
        this.assertSize((Map<?, ?>)cache1, 4);
        atomicMap = this.createAtomicMap(cache1, new MagicKey("testSizeOnCache-third", cache1), true);
        this.assertSize((Map<?, ?>)cache1, 5);
        atomicMap.put("mm", "nn");
        this.assertSize((Map<?, ?>)cache1, 5);
        atomicMap.put("ooo", "weird!");
        this.assertSize((Map<?, ?>)cache1, 5);
        atomicMap = this.createAtomicMap(cache1, new MagicKey("testSizeOnCache-onemore", cache1), true);
        this.assertSize((Map<?, ?>)cache1, 6);
        atomicMap.put("even less?", "weird!");
        this.assertSize((Map<?, ?>)cache1, 6);
        tm1.rollback();
        this.assertSize((Map<?, ?>)cache1, 4);
    }

    public void testConcurrentReadsOnExistingMap() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        this.assertSize((Map<?, ?>)cache1, 0);
        Map<String, String> map = this.createAtomicMap(cache1, "testConcurrentReadsOnExistingMap", true);
        map.put("the-1", "my preciousss");
        final Map<Object, Object> expectedMap = this.createMap("the-1", "my preciousss");
        this.tm(0, "atomic").begin();
        this.assertMap(expectedMap, map);
        final AtomicBoolean allOk = new AtomicBoolean(false);
        map.put("the-2", "a minor");
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseAtomicHashMapAPITest.this.tm(0, "atomic").begin();
                    Map map = BaseAtomicHashMapAPITest.this.createAtomicMap(cache1, "testConcurrentReadsOnExistingMap", true);
                    BaseAtomicHashMapAPITest.this.assertMap(expectedMap, map);
                    BaseAtomicHashMapAPITest.this.assertNotContainsKey(map, "the-2");
                    BaseAtomicHashMapAPITest.this.tm(0, "atomic").commit();
                    allOk.set(true);
                }
                catch (Exception e) {
                    BaseAtomicHashMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        this.tm(0, "atomic").commit();
        AssertJUnit.assertTrue((boolean)allOk.get());
    }

    public void testConcurrentWritesOnExistingMap() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        this.assertSize((Map<?, ?>)cache1, 0);
        Map<String, String> map = this.createAtomicMap(cache1, "testConcurrentReadsOnExistingMap", true);
        map.put("the-1", "my preciousss");
        final Map<Object, Object> expectedMap = this.createMap("the-1", "my preciousss");
        this.tm(0, "atomic").begin();
        this.assertMap(expectedMap, map);
        final AtomicBoolean allOk = new AtomicBoolean(false);
        map.put("the-2", "a minor");
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseAtomicHashMapAPITest.this.tm(0, "atomic").begin();
                    Map<String, String> map = BaseAtomicHashMapAPITest.this.createAtomicMap(cache1, "testConcurrentReadsOnExistingMap", true);
                    BaseAtomicHashMapAPITest.this.assertMap(expectedMap, map);
                    BaseAtomicHashMapAPITest.this.assertNotContainsKey(map, "the-2");
                    map.put("the-2", "a minor-different");
                    BaseAtomicHashMapAPITest.this.tm(0, "atomic").commit();
                }
                catch (TimeoutException e) {
                    allOk.set(true);
                }
                catch (Exception e) {
                    BaseAtomicHashMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        this.tm(0, "atomic").commit();
        AssertJUnit.assertTrue((boolean)allOk.get());
    }

    public void testConcurrentWritesAndIteration() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        this.assertSize((Map<?, ?>)cache1, 0);
        Map map = this.createAtomicMap(cache1, "testConcurrentWritesAndIteration", true);
        this.assertSize(map, 0);
        final AtomicBoolean allOk = new AtomicBoolean(true);
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    Map<String, String> map = BaseAtomicHashMapAPITest.this.createAtomicMap(cache1, "testConcurrentWritesAndIteration", true);
                    latch.await();
                    for (int i = 0; i < 500; ++i) {
                        map.put("key-" + i, "value-" + i);
                    }
                }
                catch (Exception e) {
                    BaseAtomicHashMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        Thread t2 = this.fork(new Runnable(){

            @Override
            public void run() {
                Map map = BaseAtomicHashMapAPITest.this.createAtomicMap(cache1, "testConcurrentWritesAndIteration", true);
                try {
                    latch.await();
                    for (int i = 0; i < 500; ++i) {
                        map.keySet();
                    }
                }
                catch (Exception e) {
                    allOk.set(false);
                    BaseAtomicHashMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        latch.countDown();
        t1.join();
        t2.join();
        AssertJUnit.assertTrue((String)"Iteration raised an exception.", (boolean)allOk.get());
    }

    public void testRollback() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map1 = this.createAtomicMap(cache1, "testRollback", true);
        this.tm(0, "atomic").begin();
        map1.put("k1", "v");
        map1.put("k2", "v2");
        this.tm(0, "atomic").rollback();
        Map instance = this.createAtomicMap(cache2, "testRollback", true);
        this.assertMap(Collections.emptyMap(), instance);
        this.assertMap(Collections.emptyMap(), map1);
    }

    public void testRollbackAndThenCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map1 = this.createAtomicMap(cache1, "testRollbackAndThenCommit", true);
        this.tm(0, "atomic").begin();
        map1.put("k1", "v");
        map1.put("k2", "v2");
        this.tm(0, "atomic").rollback();
        Map<Object, Object> expectedMap = Collections.emptyMap();
        Map map2 = this.createAtomicMap(cache2, "testRollbackAndThenCommit", true);
        this.assertMap(expectedMap, map2);
        this.assertMap(expectedMap, map1);
        this.tm(0, "atomic").begin();
        map1.put("k3", "v3");
        map1.put("k4", "v4");
        this.tm(0, "atomic").commit();
        expectedMap = this.createMap("k3", "v3", "k4", "v4");
        this.assertMap(expectedMap, map2);
        this.assertMap(expectedMap, map1);
    }

    public void testCreateMapInTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        this.tm(0, "atomic").begin();
        Map<String, String> map1 = this.createAtomicMap(cache1, "testCreateMapInTx", true);
        map1.put("k1", "v1");
        this.tm(0, "atomic").commit();
        Map<Object, Object> expectedMap = this.createMap("k1", "v1");
        this.assertMap(expectedMap, map1);
        Map map2 = this.createAtomicMap(cache2, "testCreateMapInTx", true);
        this.assertMap(expectedMap, map2);
    }

    public void testNoTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "testNoTx", true);
        map.put("existing", "existing");
        map.put("blah", "blah");
        Map<Object, Object> expectedMap = this.createMap("existing", "existing", "blah", "blah");
        this.assertMap(expectedMap, map);
    }

    public void testReadUncommittedValues() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        this.tm(cache1).begin();
        map.put("key one", "value one");
        map.put("blah", "blah");
        Map<Object, Object> expectedMap = this.createMap("key one", "value one", "blah", "blah");
        this.assertMap(expectedMap, map);
        Map sameAsMap = this.createAtomicMap(cache1, "testReadUncommittedValues");
        this.assertMap(expectedMap, sameAsMap);
        this.tm(cache1).commit();
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, sameAsMap);
        expectedMap = this.createMap("blah", "blah");
        this.tm(cache1).begin();
        map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        String removed = (String)map.remove("key one");
        AssertJUnit.assertEquals((String)"Wrong value removed.", (String)"value one", (String)removed);
        this.assertNotContainsKey(map, "key one");
        this.assertNotContainsValue(map, "value one");
        this.assertMap(expectedMap, map);
        this.tm(cache1).commit();
        map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        removed = (String)map.remove("key one");
        AssertJUnit.assertNull((String)"Wrong value removed.", (Object)removed);
        this.assertNotContainsKey(map, "key one");
        this.assertNotContainsValue(map, "value one");
        this.assertMap(expectedMap, map);
        expectedMap = this.createMap("key one", "value one", "blah", "blah");
        this.tm(cache1).begin();
        map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        map.put("key one", "value one");
        this.tm(cache1).commit();
        this.assertMap(expectedMap, map);
        expectedMap = this.createMap("key one", "value two", "blah", "blah");
        this.tm(cache1).begin();
        map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        map.put("key one", "value two");
        this.assertNotContainsValue(map, "value one");
        this.assertMap(expectedMap, map);
        this.tm(cache1).commit();
        map = this.createAtomicMap(cache1, "testReadUncommittedValues");
        this.assertNotContainsValue(map, "value one");
        this.assertMap(expectedMap, map);
    }

    public void testCommitReadUncommittedValues() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "testCommitReadUncommittedValues");
        this.tm(cache1).begin();
        map.put("existing", "existing");
        map.put("hey", "blah");
        this.tm(cache1).commit();
        this.tm(cache1).begin();
        map.put("key one", "fake one");
        map.put("key one", "value one");
        map.put("blah", "montevideo");
        map.put("blah", "buenos aires");
        map.remove("blah");
        map.put("blah", "toronto");
        Map<Object, Object> expectedMap = this.createMap("key one", "value one", "blah", "toronto", "existing", "existing", "hey", "blah");
        this.assertMap(expectedMap, map);
        Map sameAsMap = this.createAtomicMap(cache1, "testCommitReadUncommittedValues");
        this.assertMap(expectedMap, sameAsMap);
        this.tm(cache1).commit();
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, sameAsMap);
    }

    public void testConcurrentTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        final TransactionManager tm1 = this.tm(cache1);
        final TransactionManager tm2 = this.tm(cache2);
        final Map<String, String> map1 = this.createAtomicMap(cache1, "testConcurrentTx", true);
        Map<Object, Object> expectedMap = this.createMap("k1", "initial");
        tm1.begin();
        map1.put("k1", "initial");
        tm1.commit();
        final Map map2 = this.createAtomicMap(cache2, "testConcurrentTx", false);
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
        Thread t1 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    tm1.begin();
                    map1.put("k1", "tx1Value");
                    tm1.commit();
                }
                catch (Exception e) {
                    BaseAtomicHashMapAPITest.this.log.error((Object)e);
                }
            }
        }, false);
        Thread t2 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    tm2.begin();
                    map2.put("k2", "tx2Value");
                    tm2.commit();
                }
                catch (Exception e) {
                    BaseAtomicHashMapAPITest.this.log.error((Object)e);
                }
            }
        }, false);
        t2.join();
        t1.join();
        expectedMap = this.createMap("k1", "tx1Value", "k2", "tx2Value");
        this.assertMap(expectedMap, map1);
        this.assertMap(expectedMap, map2);
    }

    public void testReplicationPutCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "testReplicationPutCommit");
        Map<Object, Object> expectedMap = this.createMap("existing", "existing", "blah", "blah");
        this.tm(cache1).begin();
        map.put("existing", "existing");
        map.put("blah", "blah");
        this.tm(cache1).commit();
        this.assertMap(expectedMap, map);
        Map<String, String> other = this.createAtomicMap(cache2, "testReplicationPutCommit", false);
        this.assertMap(expectedMap, other);
        this.tm(cache2).begin();
        other.put("existing", "not existing");
        other.put("not existing", "peace on Earth");
        this.tm(cache2).commit();
        expectedMap = this.createMap("blah", "blah", "existing", "not existing", "not existing", "peace on Earth");
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, other);
    }

    public void testReplicationRemoveCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "testReplicationRemoveCommit");
        Map<Object, Object> expectedMap = this.createMap("existing", "existing", "blah", "blah");
        this.tm(cache1).begin();
        map.put("existing", "existing");
        map.put("blah", "blah");
        this.tm(cache1).commit();
        this.assertMap(expectedMap, map);
        Map other = this.createAtomicMap(cache2, "testReplicationRemoveCommit", false);
        this.assertMap(expectedMap, other);
        this.tm(cache2).begin();
        String removed = (String)map.remove("existing");
        AssertJUnit.assertEquals((String)("Wrong value removed from map '" + map + "'."), (String)"existing", (String)removed);
        this.tm(cache2).commit();
        expectedMap = this.createMap("blah", "blah");
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, other);
    }

    public void testReplicationPutAndClearCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        Map<String, String> map = this.createAtomicMap(cache1, "map");
        Map map2 = this.createAtomicMap(cache2, "map", false);
        Map<Object, Object> expectedMap = this.createMap("existing", "existing", "blah", "blah");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put("existing", "existing");
        map.put("blah", "blah");
        map.size();
        TestingUtil.getTransactionManager(cache1).commit();
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, map2);
        this.tm(cache2).begin();
        map2.clear();
        this.tm(cache2).commit();
        expectedMap = Collections.emptyMap();
        this.assertMap(expectedMap, map);
        this.assertMap(expectedMap, map2);
    }

    public void testDuplicateValue() {
        Cache cache = this.cache(0, "atomic");
        Map<String, String> map = this.createAtomicMap(cache, "duplicateValues", true);
        map.put("k1", "value");
        map.put("k2", "value");
        map.put("k3", "value");
        map.put("k4", "value");
        Map<Object, Object> expectedMap = this.createMap("k1", "value", "k2", "value", "k3", "value", "k4", "value");
        this.assertMap(expectedMap, map);
    }

    public void testReadEntriesCommittedInConcurrentTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        if (cache1.getCacheConfiguration().locking().isolationLevel() != IsolationLevel.REPEATABLE_READ || cache2.getCacheConfiguration().locking().isolationLevel() != IsolationLevel.REPEATABLE_READ) {
            return;
        }
        TransactionManager tm1 = this.tm(cache1);
        TransactionManager tm2 = this.tm(cache2);
        Map<String, String> writeMap = this.createAtomicMap(cache1, "repeatableReadMap", true);
        Map emptyMap = Collections.emptyMap();
        this.assertMap(emptyMap, writeMap);
        tm1.begin();
        writeMap.put("k1", "initial");
        tm1.commit();
        Map<Object, Object> initialMap = this.createMap("k1", "initial");
        this.assertMap(initialMap, writeMap);
        tm2.begin();
        Map readMap = this.createAtomicMap(cache2, "repeatableReadMap", false);
        this.assertMap(initialMap, readMap);
        Transaction tx2 = tm2.suspend();
        tm1.begin();
        writeMap.put("k1", "v1");
        writeMap.put("k2", "v2");
        writeMap.put("k3", "v3");
        Map<Object, Object> modifiedMap = this.createMap("k1", "v1", "k2", "v2", "k3", "v3");
        this.assertMap(modifiedMap, writeMap);
        tm1.commit();
        tm2.resume(tx2);
        this.assertMap(initialMap, readMap);
        tm2.commit();
        this.assertMap(modifiedMap, writeMap);
        this.assertMap(modifiedMap, readMap);
    }

    private void assertSize(Map<?, ?> map, int expectedSize) {
        int size = map.size();
        AssertJUnit.assertEquals((String)("Wrong size in map '" + map + "'."), (int)expectedSize, (int)size);
        if (size == 0) {
            this.assertEmpty(map);
        } else {
            this.assertNotEmpty(map);
        }
    }

    private void assertEmpty(Map<?, ?> map) {
        AssertJUnit.assertTrue((String)("Map '" + map + "' should be empty."), (boolean)map.isEmpty());
    }

    private void assertNotEmpty(Map<?, ?> map) {
        AssertJUnit.assertFalse((String)("Map '" + map + "' should *not* be empty."), (boolean)map.isEmpty());
    }

    private void assertKeyValue(Map<?, ?> map, Object key, Object expectedValue) {
        AssertJUnit.assertEquals((String)("Wrong value for key '" + key + "' on map '" + map + "'."), (Object)expectedValue, map.get(key));
    }

    private void assertKeysValues(Map<?, ?> expected, Map<?, ?> atomicMap) {
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            this.assertKeyValue(atomicMap, entry.getKey(), entry.getValue());
        }
    }

    private void assertNotContainsKey(Map<?, ?> map, Object key) {
        AssertJUnit.assertFalse((String)("Map '" + map + "' should *not* contain key '" + key + "'."), (boolean)map.containsKey(key));
    }

    private void assertContainsKey(Map<?, ?> map, Object key) {
        AssertJUnit.assertTrue((String)("Map '" + map + "' should contain key '" + key + "'."), (boolean)map.containsKey(key));
    }

    private void assertNotContainsValue(Map<?, ?> map, Object value) {
        AssertJUnit.assertFalse((String)("Map '" + map + "' should *not* contain value '" + value + "'."), (boolean)map.containsValue(value));
    }

    private void assertContainsValue(Map<?, ?> map, Object value) {
        AssertJUnit.assertTrue((String)("Map '" + map + "' should contain value '" + value + "'."), (boolean)map.containsValue(value));
    }

    protected void assertMap(Map<?, ?> expected, Map<?, ?> atomicMap) {
        AssertJUnit.assertEquals(expected, new HashMap(atomicMap));
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.size()"), (int)expected.size(), (int)atomicMap.size());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.isEmpty()"), (boolean)expected.isEmpty(), (boolean)atomicMap.isEmpty());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.keySet().size()"), (int)expected.keySet().size(), (int)atomicMap.keySet().size());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.keySet().isEmpty()"), (boolean)expected.keySet().isEmpty(), (boolean)atomicMap.keySet().isEmpty());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.values().size()"), (int)expected.values().size(), (int)atomicMap.values().size());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.values().isEmpty()"), (boolean)expected.values().isEmpty(), (boolean)atomicMap.values().isEmpty());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.entrySet().size()"), (int)expected.entrySet().size(), (int)atomicMap.entrySet().size());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.entrySet().isEmpty()"), (boolean)expected.entrySet().isEmpty(), (boolean)atomicMap.entrySet().isEmpty());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.keySet() content."), expected.keySet(), atomicMap.keySet());
        AssertJUnit.assertEquals((String)("Wrong map '" + atomicMap + "'.values() content."), new HashSet(expected.values()), new HashSet(atomicMap.values()));
        for (Map.Entry<?, ?> entry : atomicMap.entrySet()) {
            AssertJUnit.assertEquals((String)("Wrong value for key " + entry.getKey()), expected.get(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Object, Object> key : expected.keySet()) {
            this.assertContainsKey(atomicMap, key);
        }
        for (Map.Entry<Object, Object> value : expected.values()) {
            this.assertContainsValue(atomicMap, value);
        }
        this.assertKeysValues(expected, atomicMap);
    }

    protected Map<Object, Object> createMap(Object ... keysAndValues) {
        AssertJUnit.assertEquals((String)"Wrong parameters in createMap() method.", (int)0, (int)(keysAndValues.length % 2));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    protected abstract <CK, K, V> Map<K, V> createAtomicMap(Cache<CK, Object> var1, CK var2, boolean var3);

    protected final <CK, K, V> Map<K, V> createAtomicMap(Cache<CK, Object> cache, CK key) {
        return this.createAtomicMap(cache, key, true);
    }
}

