/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.transaction.Transaction;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseAtomicMapLockingTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 3;
    private static final String VALUE = "value";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final boolean pessimistic;
    private final CollectCompositeKeysInterceptor[] collectors = new CollectCompositeKeysInterceptor[3];
    private final ControlledRpcManager[] rpcManagers = new ControlledRpcManager[3];
    private Object ahmKey;
    private Object fgahmKey;

    protected BaseAtomicMapLockingTest(boolean pessimistic) {
        this.pessimistic = pessimistic;
    }

    public final void testAtomicHasMapLockingOnLockOwner() throws Exception {
        this.testAtomicHashMap(true);
    }

    public final void testAtomicHasMapLockingOnNonLockOwner() throws Exception {
        this.testAtomicHashMap(false);
    }

    public final void testFineGrainedAtomicHashMapLockingOnLockOwner() throws Exception {
        this.testFineGrainedAtomicHashMap(true);
    }

    public final void testFineGrainedAtomicHashMapLockingOnNonLockOwner() throws Exception {
        this.testFineGrainedAtomicHashMap(false);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        int i;
        for (i = 0; i < 3; ++i) {
            this.collectors[i] = new CollectCompositeKeysInterceptor();
            ConfigurationBuilder builder = BaseAtomicMapLockingTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
            builder.transaction().lockingMode(this.pessimistic ? LockingMode.PESSIMISTIC : LockingMode.OPTIMISTIC);
            builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)this.collectors[i]).before(TxInterceptor.class);
            builder.clustering().hash().numOwners(2);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
        for (i = 0; i < 3; ++i) {
            RpcManager rpcManager = TestingUtil.extractComponent(this.cache(i), RpcManager.class);
            this.rpcManagers[i] = new ControlledRpcManager(rpcManager);
            TestingUtil.replaceComponent(this.cache(i), RpcManager.class, this.rpcManagers[i], true);
        }
        this.ahmKey = new MagicKey("AtomicHashMap", this.cache(0));
        this.fgahmKey = new MagicKey("FineGrainedAtomicHashMap", this.cache(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void testAtomicHashMap(boolean executeOnLockOwner) throws Exception {
        this.resetBeforeMethod();
        final int txExecutor = executeOnLockOwner ? 0 : 1;
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache(txExecutor), (Object)this.ahmKey);
        this.tm(txExecutor).begin();
        map.put((Object)"key1", (Object)VALUE);
        map.put((Object)"key2", (Object)VALUE);
        map.put((Object)"key3", (Object)VALUE);
        final Transaction tx1 = this.tm(txExecutor).suspend();
        if (this.pessimistic) {
            this.rpcManagers[txExecutor].blockBefore(PrepareCommand.class);
        } else {
            this.rpcManagers[txExecutor].blockAfter(PrepareCommand.class);
        }
        Future<Boolean> txOutcome = this.fork(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    BaseAtomicMapLockingTest.this.tm(txExecutor).resume(tx1);
                    BaseAtomicMapLockingTest.this.tm(txExecutor).commit();
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    return Boolean.FALSE;
                }
            }
        });
        try {
            this.rpcManagers[txExecutor].waitForCommandToBlock();
            this.assertKeysLocked(0, this.ahmKey);
            this.assertKeysLocked(1, EMPTY_ARRAY);
            this.assertKeysLocked(2, EMPTY_ARRAY);
            this.rpcManagers[txExecutor].stopBlocking();
            Assert.assertTrue((boolean)txOutcome.get());
        }
        finally {
            this.rpcManagers[txExecutor].stopBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void testFineGrainedAtomicHashMap(boolean executeOnLockOwner) throws Exception {
        this.resetBeforeMethod();
        final int txExecutor = executeOnLockOwner ? 0 : 1;
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(this.cache(txExecutor), (Object)this.fgahmKey);
        boolean hasLocalKeys = false;
        boolean hasRemoteKeys = false;
        int keyIndex = 0;
        this.tm(txExecutor).begin();
        while (!hasLocalKeys || !hasRemoteKeys) {
            map.put((Object)("key" + keyIndex++), (Object)VALUE);
            hasLocalKeys = this.hasKeyMappedTo(true, this.collectors[txExecutor].getCompositeKeys());
            hasRemoteKeys = this.hasKeyMappedTo(false, this.collectors[txExecutor].getCompositeKeys());
        }
        final Transaction tx1 = this.tm(txExecutor).suspend();
        Assert.assertEquals((int)this.collectors[txExecutor].getCompositeKeys().size(), (int)keyIndex, (String)"Wrong number of composite keys collected!");
        this.log.infof("%s composite keys collected.", (Object)this.collectors[txExecutor].getCompositeKeys().size());
        if (this.pessimistic) {
            this.rpcManagers[txExecutor].blockBefore(PrepareCommand.class);
        } else {
            this.rpcManagers[txExecutor].blockAfter(PrepareCommand.class);
        }
        Future<Boolean> txOutcome = this.fork(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    BaseAtomicMapLockingTest.this.tm(txExecutor).resume(tx1);
                    BaseAtomicMapLockingTest.this.tm(txExecutor).commit();
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    return Boolean.FALSE;
                }
            }
        });
        try {
            this.rpcManagers[txExecutor].waitForCommandToBlock();
            this.assertKeysLocked(0, this.collectors[txExecutor].getCompositeKeys().toArray());
            this.assertKeysLocked(1, EMPTY_ARRAY);
            this.assertKeysLocked(2, EMPTY_ARRAY);
            this.rpcManagers[txExecutor].stopBlocking();
            Assert.assertTrue((boolean)txOutcome.get());
        }
        finally {
            this.rpcManagers[txExecutor].stopBlocking();
        }
    }

    protected void assertKeysLocked(int index, Object ... keys) {
        LockManager lockManager = this.lockManager(index);
        Assert.assertNotNull((Object)keys);
        for (Object key : keys) {
            Assert.assertTrue((boolean)lockManager.isLocked(key), (String)(key + " is not locked in cache(" + index + ")."));
        }
    }

    protected boolean hasKeyMappedTo(boolean toLockOwner, Collection<Object> keys) {
        for (Object key : keys) {
            boolean onLockOwner = DistributionTestHelper.isFirstOwner(this.cache(0), key);
            if ((!toLockOwner || !onLockOwner) && (toLockOwner || onLockOwner)) continue;
            return true;
        }
        return false;
    }

    private void resetBeforeMethod() {
        for (int i = 0; i < 3; ++i) {
            if (this.collectors[i] != null) {
                this.collectors[i].reset();
            }
            if (this.rpcManagers[i] == null) continue;
            this.rpcManagers[i].stopBlocking();
            this.rpcManagers[i].stopFailing();
        }
    }

    private static class CollectCompositeKeysInterceptor
    extends BaseCustomInterceptor {
        private final Set<Object> compositeKeys = new HashSet<Object>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            Set<Object> set = this.compositeKeys;
            synchronized (set) {
                this.compositeKeys.addAll(Arrays.asList(command.getCompositeKeys()));
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset() {
            Set<Object> set = this.compositeKeys;
            synchronized (set) {
                this.compositeKeys.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Collection<Object> getCompositeKeys() {
            Set<Object> set = this.compositeKeys;
            synchronized (set) {
                return new ArrayList<Object>(this.compositeKeys);
            }
        }
    }
}

