/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.ClusteredAtomicMapPassivationTest")
public class ClusteredAtomicMapPassivationTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ClusteredAtomicMapPassivationTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        builder.eviction().maxEntries(1024).loaders().passivation(true).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore());
        this.createClusteredCaches(2, "atomic", builder);
    }

    public void testEviction() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TestingUtil.withTx(tm1, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)cache1, (Object)"map");
                map.put((Object)"key1", (Object)"value1");
                map.put((Object)"key2", (Object)"value2");
                return null;
            }
        });
        cache2.evict((Object)"map");
        TestingUtil.withTx(tm1, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)cache1, (Object)"map");
                map.put((Object)"key1", (Object)"new_value1");
                AssertJUnit.assertTrue((boolean)map.containsKey((Object)"key2"));
                AssertJUnit.assertEquals((String)"value2", (String)((String)map.get((Object)"key2")));
                return null;
            }
        });
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache2, (Object)"map");
        AssertJUnit.assertTrue((boolean)map.containsKey((Object)"key1"));
        AssertJUnit.assertTrue((boolean)map.containsKey((Object)"key2"));
        AssertJUnit.assertEquals((String)"new_value1", (String)((String)map.get((Object)"key1")));
        AssertJUnit.assertEquals((String)"value2", (String)((String)map.get((Object)"key2")));
    }
}

