/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import org.infinispan.atomic.LocalDeltaAwareEvictionTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.ReplDeltaAwareEvictionTest")
@CleanupAfterMethod
public class ReplDeltaAwareEvictionTest
extends LocalDeltaAwareEvictionTest {
    public ReplDeltaAwareEvictionTest() {
        this.txEnabled = true;
    }

    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder builder = ReplDeltaAwareEvictionTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true, true);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new JBossStandaloneJTAManagerLookup()).eviction().maxEntries(1).strategy(EvictionStrategy.LRU).loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).fetchPersistentState(false);
        this.addClusterEnabledCacheManager(builder);
        builder.loaders().clearCacheLoaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).fetchPersistentState(false);
        this.addClusterEnabledCacheManager(builder);
        this.waitForClusterToForm();
    }

    @Override
    public void testDeltaAware() throws Exception {
        this.test(this.createDeltaAwareAccessor(), 0, 1);
    }

    public void testDeltaAware2() throws Exception {
        this.test(this.createDeltaAwareAccessor(), 1, 0);
    }

    @Override
    public void testAtomicMap() throws Exception {
        this.test(this.createAtomicMapAccessor(), 0, 1);
    }

    public void testAtomicMap2() throws Exception {
        this.test(this.createAtomicMapAccessor(), 1, 0);
    }

    @Override
    public void testFineGrainedAtomicMap() throws Exception {
        this.test(this.createFineGrainedAtomicMapAccessor(), 0, 1);
    }

    public void testFineGrainedAtomicMap2() throws Exception {
        this.test(this.createFineGrainedAtomicMapAccessor(), 1, 0);
    }
}

