/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import org.infinispan.atomic.ReplDeltaAwareEvictionTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.ReplDeltaAwarePassivationTest")
@CleanupAfterMethod
public class ReplDeltaAwarePassivationTest
extends ReplDeltaAwareEvictionTest {
    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder builder = ReplDeltaAwarePassivationTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true, true);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new JBossStandaloneJTAManagerLookup()).eviction().maxEntries(1).strategy(EvictionStrategy.LRU).loaders().passivation(true).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).fetchPersistentState(false);
        this.addClusterEnabledCacheManager(builder);
        builder.loaders().clearCacheLoaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).fetchPersistentState(false);
        this.addClusterEnabledCacheManager(builder);
        this.waitForClusterToForm();
    }

    @Override
    protected void assertNumberOfEntries(int cacheIndex) throws Exception {
        CacheStore cacheStore = TestingUtil.extractComponent(this.cache(cacheIndex), CacheLoaderManager.class).getCacheStore();
        Assert.assertEquals((long)1L, (long)cacheStore.loadAllKeys(null).size());
        DataContainer dataContainer = this.cache(cacheIndex).getAdvancedCache().getDataContainer();
        Assert.assertEquals((long)1L, (long)dataContainer.size());
    }
}

