/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.RepeatableReadAtomicMapAPITest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.distribution.MagicKey;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.ReplWriteSkewAtomicMapAPITest")
public class ReplWriteSkewAtomicMapAPITest
extends RepeatableReadAtomicMapAPITest {
    public void testWriteSkewOnPrimaryOwner() throws Exception {
        this.doWriteSkewTest(this.cache(0, "atomic"), new MagicKey(this.cache(0, "atomic"), this.cache(1, "atomic")), this.caches("atomic"));
    }

    public void testWriteSkewOnBackupOwner() throws Exception {
        this.doWriteSkewTest(this.cache(1, "atomic"), new MagicKey(this.cache(0, "atomic"), this.cache(1, "atomic")), this.caches("atomic"));
    }

    public void testWriteSkewOnNonOwner() throws Exception {
        this.doWriteSkewTest(this.cache(2, "atomic"), new MagicKey(this.cache(0, "atomic"), this.cache(1, "atomic")), this.caches("atomic"));
    }

    @Override
    public void testConcurrentWritesOnExistingMap() throws Exception {
    }

    @Override
    public void testConcurrentTx() throws Exception {
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, "atomic", this.configuration());
    }

    private void doWriteSkewTest(Cache<Object, Object> cache, Object mapKey, List<Cache<Object, Object>> caches) throws Exception {
        TransactionManager tm = this.tm(cache);
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap(cache, (Object)mapKey, (boolean)true);
        atomicMap.put("k1", "v1");
        tm.begin();
        AssertJUnit.assertEquals((Object)"v1", atomicMap.get("k1"));
        Transaction tx1 = tm.suspend();
        tm.begin();
        AssertJUnit.assertEquals((Object)"v1", atomicMap.get("k1"));
        Transaction tx2 = tm.suspend();
        tm.resume(tx1);
        atomicMap.put("k1", "v2");
        tm.commit();
        tm.resume(tx2);
        AssertJUnit.assertEquals((Object)"v1", atomicMap.get("k1"));
        atomicMap.put("k1", "v3");
        try {
            tm.commit();
            AssertJUnit.fail();
        }
        catch (RollbackException e) {
            ReplWriteSkewAtomicMapAPITest.safeRollback(tm);
        }
        for (Cache<Object, Object> cache1 : caches) {
            AssertJUnit.assertEquals((Object)"v2", (Object)AtomicMapLookup.getAtomicMap(cache1, (Object)mapKey).get((Object)"k1"));
        }
    }

    private ConfigurationBuilder configuration() {
        ConfigurationBuilder configurationBuilder = ReplWriteSkewAtomicMapAPITest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.OPTIMISTIC).locking().lockAcquisitionTimeout(100L).isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).versioning().enable().scheme(VersioningScheme.SIMPLE).clustering().hash().numOwners(2).stateTransfer().fetchInMemoryState(false);
        return configurationBuilder;
    }
}

