/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.Serializable;
import java.util.HashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;

public class TestDeltaAware
implements DeltaAware,
Serializable {
    private String firstComponent;
    private String secondComponent;
    private transient TestDelta delta;

    public void commit() {
        this.delta = null;
    }

    public Delta delta() {
        TestDelta toReturn = this.getDelta();
        this.delta = null;
        return toReturn;
    }

    private TestDelta getDelta() {
        if (this.delta == null) {
            this.delta = new TestDelta();
        }
        return this.delta;
    }

    public String getFirstComponent() {
        return this.firstComponent;
    }

    public void setFirstComponent(String firstComponent) {
        this.getDelta().registerComponentChange("firstComponent", firstComponent);
        this.firstComponent = firstComponent;
    }

    public String getSecondComponent() {
        return this.secondComponent;
    }

    public void setSecondComponent(String secondComponent) {
        this.getDelta().registerComponentChange("secondComponent", secondComponent);
        this.secondComponent = secondComponent;
    }

    static class TestDelta
    implements Delta,
    Serializable {
        private final HashMap<String, String> changeLog = new HashMap();

        TestDelta() {
        }

        void registerComponentChange(String componentName, String componentValue) {
            this.changeLog.put(componentName, componentValue);
        }

        public DeltaAware merge(DeltaAware d) {
            TestDeltaAware other = d instanceof TestDeltaAware ? (TestDeltaAware)d : new TestDeltaAware();
            for (String componentName : this.changeLog.keySet()) {
                String componentValue = this.changeLog.get(componentName);
                if (componentName.equals("firstComponent")) {
                    other.firstComponent = componentValue;
                    continue;
                }
                if (componentName.equals("secondComponent")) {
                    other.secondComponent = componentValue;
                    continue;
                }
                throw new RuntimeException("Unknown component: " + componentName);
            }
            return other;
        }
    }
}

