/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.HashMap;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.PutMapCommandTest")
public class PutMapCommandTest
extends MultipleCacheManagersTest {
    protected int numberOfKeys = 10;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = PutMapCommandTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1).l1().disable();
        dcc.locking().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.createCluster(dcc, 4);
        this.waitForClusterToForm();
    }

    public void testPutOnNonOwner() {
        MagicKey mk = new MagicKey("key", this.cache(0));
        this.cache(3).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)mk, (Object)"value");
        assert (this.cache(0).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)mk) != null);
        assert (this.cache(1).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)mk) == null);
        assert (this.cache(2).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)mk) == null);
        assert (this.cache(3).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)mk) == null);
    }

    public void testPutMapCommand() {
        int i;
        for (int i2 = 0; i2 < this.numberOfKeys; ++i2) {
            assert (this.cache(0).get((Object)("key" + i2)) == null);
            assert (this.cache(1).get((Object)("key" + i2)) == null);
            assert (this.cache(2).get((Object)("key" + i2)) == null);
            assert (this.cache(3).get((Object)("key" + i2)) == null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (i = 0; i < this.numberOfKeys; ++i) {
            map.put("key" + i, "value" + i);
        }
        this.cache(0).putAll(map);
        i = 0;
        while (i < this.numberOfKeys) {
            Assert.assertEquals((Object)("value" + i), (Object)this.cache(0).get((Object)("key" + i)));
            final int finalI = i++;
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return PutMapCommandTest.this.cache(1).get((Object)("key" + finalI)).equals("value" + finalI);
                }
            });
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return PutMapCommandTest.this.cache(2).get((Object)("key" + finalI)).equals("value" + finalI);
                }
            });
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return PutMapCommandTest.this.cache(3).get((Object)("key" + finalI)).equals("value" + finalI);
                }
            });
        }
    }
}

