/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.lang.reflect.Method;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ConfigurationCloneTest")
public class ConfigurationCloneTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager(false);
    }

    public void testCloningBeforeStart(Method method) {
        Configuration defaultConfig = this.cacheManager.defineConfiguration("default", new Configuration());
        Configuration clone = defaultConfig.clone();
        assert (clone.equals((Object)defaultConfig));
        clone.setEvictionMaxEntries(123);
        String name = method.getName() + "-default";
        this.cacheManager.defineConfiguration(name, clone);
        this.cacheManager.getCache(name);
    }

    public void testCloningAfterStart(Method method) {
        Configuration defaultConfig = this.cacheManager.getCache("default").getConfiguration();
        Configuration clone = defaultConfig.clone();
        assert (clone.equals((Object)defaultConfig));
        clone.setEvictionMaxEntries(456);
        String name = method.getName() + "-default";
        this.cacheManager.defineConfiguration(name, clone);
        this.cacheManager.getCache(name);
    }

    public void testDoubleCloning(Method method) {
        block4: {
            String name = method.getName();
            Configuration defaultConfig = this.cacheManager.defineConfiguration(name + "-default", new Configuration());
            Configuration clone = defaultConfig.clone();
            assert (clone.equals((Object)defaultConfig));
            clone.setEvictionMaxEntries(789);
            this.cacheManager.defineConfiguration(name + "-new-default", clone);
            this.cacheManager.getCache(name + "-new-default");
            Configuration otherDefaultConfig = this.cacheManager.getCache(name + "-default").getConfiguration();
            Configuration otherClone = otherDefaultConfig.clone();
            assert (otherClone.equals((Object)otherDefaultConfig));
            otherClone.setEvictionMaxEntries(788);
            try {
                this.cacheManager.defineConfiguration(name + "-new-default", otherClone);
            }
            catch (ConfigurationException e) {
                String message = e.getMessage();
                if ($assertionsDisabled || message.contains("[maxEntries]")) break block4;
                throw new AssertionError((Object)("Exception should indicate that it's Eviction maxEntries that we're trying to override but it says: " + message));
            }
        }
    }

    public void testGlobalConfigurationCloning(Method m) {
        GlobalConfiguration clone = this.cacheManager.getGlobalConfiguration().clone();
        String newJmxDomain = m.getName();
        clone.setJmxDomain(newJmxDomain);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(clone);
        assert (cacheManager.getGlobalConfiguration().getJmxDomain().equals(newJmxDomain));
    }
}

