/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.infinispan.config.parsing.ConfigFilesConvertor;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.Jbc2InfinispanTransformerTest")
public class Jbc2InfinispanTransformerTest
extends AbstractInfinispanTest {
    public static final String XSLT_FILE = "xslt/jbc3x2infinispan4x.xslt";
    private static final String BASE_DIR = "configs/jbosscache3x";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllFile() throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        try {
            TestClassLoader delegatingCl = new TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            String fileName = this.getFileName("all.xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE, Thread.currentThread().getContextClassLoader());
            System.out.println("Output file is:\n" + baos.toString());
            TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.fromStream(new ByteArrayInputStream(baos.toByteArray()))){

                @Override
                public void call() {
                    Configuration defaultConfig = this.cm.getDefaultCacheConfiguration();
                    GlobalConfiguration globalConfig = this.cm.getCacheManagerConfiguration();
                    assert (defaultConfig.locking().isolationLevel().equals((Object)IsolationLevel.READ_COMMITTED));
                    assert (defaultConfig.locking().lockAcquisitionTimeout() == 234000L);
                    assert (defaultConfig.locking().concurrencyLevel() == 510);
                    assert (defaultConfig.transaction().transactionManagerLookup().getClass().equals(GenericTransactionManagerLookup.class));
                    assert (!defaultConfig.transaction().syncCommitPhase());
                    assert (defaultConfig.transaction().syncRollbackPhase());
                    assert (defaultConfig.jmxStatistics().enabled());
                    assert (globalConfig.shutdown().hookBehavior().equals((Object)ShutdownHookBehavior.DONT_REGISTER));
                    assert (globalConfig.asyncListenerExecutor().properties().get((Object)"maxThreads").equals("123"));
                    assert (globalConfig.asyncListenerExecutor().properties().get((Object)"queueSize").equals("1020000"));
                    assert (!defaultConfig.invocationBatching().enabled());
                    assert (globalConfig.serialization().marshaller().getClass().equals(VersionAwareMarshaller.class));
                    assert (defaultConfig.storeAsBinary().enabled());
                    assert (globalConfig.transport().clusterName().equals("JBossCache-cluster"));
                    assert (defaultConfig.clustering().cacheMode().equals((Object)CacheMode.INVALIDATION_SYNC));
                    assert (defaultConfig.clustering().stateTransfer().timeout() == 2120000L);
                    assert (defaultConfig.clustering().sync().replTimeout() == 22220000L);
                    assert (defaultConfig.eviction().strategy() == EvictionStrategy.LRU);
                    assert (defaultConfig.eviction().maxEntries() == 5001);
                    assert (defaultConfig.expiration().maxIdle() == 1001L) : "Received " + defaultConfig.expiration().lifespan();
                    assert (defaultConfig.expiration().wakeUpInterval() == 50015L);
                    Configuration regionOne = this.cm.getCacheConfiguration("/org/jboss/data1");
                    assert (regionOne != null);
                    assert (regionOne.eviction().strategy() == EvictionStrategy.LRU);
                    assert (regionOne.expiration().maxIdle() == 2002L);
                    assert (regionOne.expiration().wakeUpInterval() == 50015L);
                    Configuration regionTwo = this.cm.getCacheConfiguration("/org/jboss/data2");
                    assert (regionTwo != null);
                    assert (regionTwo.eviction().strategy() == EvictionStrategy.FIFO);
                    assert (regionTwo.eviction().maxEntries() == 3003);
                    assert (regionTwo.expiration().wakeUpInterval() == 50015L);
                    LoadersConfiguration loaders = defaultConfig.loaders();
                    assert (loaders.passivation());
                    assert (loaders.shared());
                    assert (loaders.cacheLoaders().size() == 1);
                    FileCacheStoreConfiguration fcsc = (FileCacheStoreConfiguration)loaders.cacheLoaders().get(0);
                    assert (fcsc.async().enabled());
                    assert (fcsc.fetchPersistentState());
                    assert (fcsc.ignoreModifications());
                    assert (fcsc.purgeOnStartup());
                    assert (fcsc.singletonStore().enabled());
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanTransformExistingFiles() throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        try {
            String[] testFiles;
            TestClassLoader delegatingCl = new TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            for (String name : testFiles = new String[]{"buddy-replication.xml", "cacheloader-enabled.xml", "eviction-enabled.xml", "external-jgroups-file.xml", "invalidation-async.xml", "total-replication.xml"}) {
                String fileName = this.getFileName(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE, Thread.currentThread().getContextClassLoader());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(existingCl);
        }
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }

    public static class TestClassLoader
    extends ClassLoader {
        private ClassLoader existing;

        TestClassLoader(ClassLoader existing) {
            super(existing);
            this.existing = existing;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.equals("org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore")) {
                return DummyInMemoryCacheStore.class;
            }
            return this.existing.loadClass(name);
        }
    }
}

