/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.SyncConsistentHashFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.HashConfigurationBuilderTest")
public class HashConfigurationBuilderTest
extends AbstractInfinispanTest {
    public void testNumOwners() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.clustering().hash().numOwners(5);
        Configuration c = cb.build();
        Assert.assertEquals((int)5, (int)c.clustering().hash().numOwners());
        try {
            cb.clustering().hash().numOwners(0);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNumSegments() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.clustering().hash().numSegments(5);
        Configuration c = cb.build();
        Assert.assertEquals((int)5, (int)c.clustering().hash().numSegments());
        try {
            cb.clustering().hash().numSegments(0);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConsistentHashFactory() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        Configuration c = cb.build();
        Assert.assertNull((Object)c.clustering().hash().consistentHashFactory());
        SyncConsistentHashFactory consistentHashFactory = new SyncConsistentHashFactory();
        cb.clustering().hash().consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        c = cb.build();
        Assert.assertSame((Object)c.clustering().hash().consistentHashFactory(), (Object)consistentHashFactory);
    }
}

