/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(testName="container.versioning.VersionedDistStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class VersionedDistStateTransferTest
extends MultipleCacheManagersTest {
    ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        this.builder.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().versioning().enable().scheme(VersioningScheme.SIMPLE).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).transaction().lockingMode(LockingMode.OPTIMISTIC).syncCommitPhase(true);
        this.createCluster(this.builder, 4);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", cache2);
        cache0.put((Object)hello, (Object)"world");
        this.checkStateTransfer(hello);
        this.tm(1).begin();
        assert ("world".equals(cache1.get((Object)hello)));
        Transaction t = this.tm(1).suspend();
        this.log.debugf("Starting joiner", new Object[0]);
        this.addClusterEnabledCacheManager(this.builder);
        Cache cache4 = this.cache(4);
        this.log.debugf("Joiner started, checking transferred data", new Object[0]);
        this.checkStateTransfer(hello);
        this.log.debugf("Stopping cache %s", cache2);
        ((EmbeddedCacheManager)this.cacheManagers.get(2)).stop();
        this.cacheManagers.remove(2);
        this.log.debugf("Leaver stopped, checking transferred data", new Object[0]);
        this.checkStateTransfer(hello);
        cache4.put((Object)hello, (Object)"new world");
        this.tm(1).resume(t);
        cache1.put((Object)hello, (Object)"world2");
        try {
            this.tm(1).commit();
            assert (false) : "Should fail";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        assert ("new world".equals(cache0.get((Object)hello)));
        assert ("new world".equals(cache1.get((Object)hello)));
        assert ("new world".equals(cache3.get((Object)hello)));
        assert ("new world".equals(cache3.get((Object)hello)));
    }

    private void checkStateTransfer(MagicKey hello) {
        for (Cache c : this.caches()) {
            assert ("world".equals(c.get((Object)hello)));
            this.checkVersion(c, hello);
        }
    }

    private void checkVersion(Cache<Object, Object> c, MagicKey hello) {
        Address address = c.getCacheManager().getAddress();
        ConsistentHash readConsistentHash = c.getAdvancedCache().getDistributionManager().getReadConsistentHash();
        if (readConsistentHash.isKeyLocalToNode(address, (Object)hello)) {
            InternalCacheEntry ice = c.getAdvancedCache().getDataContainer().get((Object)hello);
            assert (ice != null);
            assert (ice.getVersion() != null);
        }
    }
}

