/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.io.Serializable;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="context.MarshalledValueContextTest", groups={"functional"})
public class MarshalledValueContextTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = TestCacheManagerFactory.getDefaultConfiguration(true).fluent().storeAsBinary().transaction().lockingMode(LockingMode.PESSIMISTIC).build();
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void testContentsOfContext() throws Exception {
        Cache c = this.cacheManager.getCache();
        ContextExtractingInterceptor cex = new ContextExtractingInterceptor();
        c.getAdvancedCache().addInterceptorAfter((CommandInterceptor)cex, InvocationContextInterceptor.class);
        c.put((Object)new Key("k"), (Object)"v");
        assert ("v".equals(c.get((Object)new Key("k"))));
        TransactionManager tm = c.getAdvancedCache().getTransactionManager();
        tm.begin();
        c.getAdvancedCache().lock((Object[])new Key[]{new Key("k")});
        LockManager lockManager = TestingUtil.extractComponent(c, LockManager.class);
        assert (cex.ctx instanceof LocalTxInvocationContext);
        assert (cex.ctx.getLookedUpEntries().size() == 0) : "Looked up key should not be in transactional invocation context as we don't perform any changes";
        Assert.assertEquals((int)lockManager.getNumberOfLocksHeld(), (int)1, (String)"Only one lock should be held");
        c.put((Object)new Key("k"), (Object)"v2");
        assert (cex.ctx.getLookedUpEntries().size() == 1) : "Still should only be one entry in the context";
        assert (lockManager.getNumberOfLocksHeld() == 1) : "Only one lock should be held";
        tm.commit();
        assert (lockManager.getNumberOfLocksHeld() == 0) : "No locks should be held anymore";
        assert ("v2".equals(c.get((Object)new Key("k"))));
    }

    private static class Key
    implements Serializable {
        String actualKey;

        private Key(String actualKey) {
            this.actualKey = actualKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return !(this.actualKey != null ? !this.actualKey.equals(key.actualKey) : key.actualKey != null);
        }

        public int hashCode() {
            return this.actualKey != null ? this.actualKey.hashCode() : 0;
        }
    }

    private static class ContextExtractingInterceptor
    extends CommandInterceptor {
        InvocationContext ctx;

        private ContextExtractingInterceptor() {
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            this.ctx = ctx;
            return super.invokeNextInterceptor(ctx, command);
        }
    }
}

