/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.distexec.DistributedTaskFailoverPolicy;
import org.infinispan.distexec.FailoverContext;
import org.infinispan.distexec.LocalDistributedExecutorTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.BasicDistributedExecutorTest")
public class BasicDistributedExecutorTest
extends AbstractCacheTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testImproperMasterCacheForDistributedExecutor() {
        DefaultExecutorService des = new DefaultExecutorService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testImproperLocalExecutorServiceForDistributedExecutor() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = cacheManager.getCache();
            DefaultExecutorService defaultExecutorService = new DefaultExecutorService(cache, null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testStoppedLocalExecutorServiceForDistributedExecutor() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        DefaultExecutorService des = null;
        try {
            Cache cache = cacheManager.getCache();
            WithinThreadExecutor service = new WithinThreadExecutor();
            service.shutdown();
            des = new DefaultExecutorService(cache, (ExecutorService)service);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedExecutorWithPassedThreadExecutor() throws ExecutionException, InterruptedException {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache = cacheManager.getCache();
            WithinThreadExecutor service = new WithinThreadExecutor();
            des = new DefaultExecutorService(cache, (ExecutorService)service);
            Future future = des.submit((Callable)new SimpleCallable());
            Integer r = (Integer)future.get();
            assert (r == 1);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class})
    public void testStoppedCacheForDistributedExecutor() {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        try {
            Cache cache = cacheManager.getCache();
            cache.stop();
            DefaultExecutorService des = new DefaultExecutorService(cache);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedExecutorShutDown() {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache = cacheManager.getCache();
            des = new DefaultExecutorService(cache);
            des.shutdown();
            assert (des.isShutdown());
            assert (des.isTerminated());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedExecutorRealShutdown() {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        WithinThreadExecutor service = null;
        try {
            Cache cache = cacheManager.getCache();
            service = new WithinThreadExecutor();
            des = new DefaultExecutorService(cache, (ExecutorService)service);
            des.shutdown();
            assert (des.isShutdown());
            assert (des.isTerminated());
            assert (!service.isShutdown());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            service.shutdown();
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
        service.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedExecutorRealShutdownWithOwnership() {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        WithinThreadExecutor service = null;
        try {
            Cache cache = cacheManager.getCache();
            service = new WithinThreadExecutor();
            des = new DefaultExecutorService(cache, (ExecutorService)service, true);
            des.shutdown();
            assert (des.isShutdown());
            assert (des.isTerminated());
            assert (service.isShutdown());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedExecutorShutDownNow() {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        try {
            Cache cache = cacheManager.getCache();
            DefaultExecutorService des = new DefaultExecutorService(cache);
            assert (!des.isShutdown());
            assert (!des.isTerminated());
            des.shutdownNow();
            assert (des.isShutdown());
            assert (des.isTerminated());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleCacheExecution() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache = cacheManager.getCache();
            des = new DefaultExecutorService(cache);
            Future future = des.submit((Callable)new SimpleCallable());
            Integer r = (Integer)future.get();
            assert (r == 1);
            List list = des.submitEverywhere((Callable)new SimpleCallable());
            AssertJUnit.assertEquals((int)1, (int)list.size());
            for (Future f : list) {
                AssertJUnit.assertEquals((Object)new Integer(1), f.get());
            }
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        des.shutdownNow();
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleCacheWithKeysExecution() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache c1 = cacheManager.getCache();
            c1.put((Object)"key1", (Object)"Manik");
            c1.put((Object)"key2", (Object)"Mircea");
            c1.put((Object)"key3", (Object)"Galder");
            c1.put((Object)"key4", (Object)"Sanne");
            des = new DefaultExecutorService(c1);
            Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
            Boolean r = (Boolean)future.get();
            assert (r.booleanValue());
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        des.shutdownNow();
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableCustomFailoverPolicySuccessfullRetry() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache1 = cacheManager.getCache();
            cache1.put((Object)"key1", (Object)"value1");
            cache1.put((Object)"key2", (Object)"value2");
            des = new DefaultExecutorService(cache1);
            DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new FailOnlyOnceCallable());
            taskBuilder.failoverPolicy(new DistributedTaskFailoverPolicy(){

                public Address failover(FailoverContext context) {
                    return context.executionFailureLocation();
                }

                public int maxFailoverAttempts() {
                    return 1;
                }
            });
            DistributedTask task = taskBuilder.build();
            AssertJUnit.assertEquals((int)1, (int)task.getTaskFailoverPolicy().maxFailoverAttempts());
            Future val = des.submit(task, (Object[])new String[]{"key1"});
            AssertJUnit.assertEquals((Object)new Integer(1), val.get());
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        des.shutdownNow();
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableWithFailingKeysSuccessfullRetry() throws Exception {
        Configuration config = BasicDistributedExecutorTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        config.setNumOwners(1);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(config);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache1 = cacheManager1.getCache("cache1");
            cache1.put((Object)"key1", (Object)"value1");
            cache1.put((Object)"key2", (Object)"value2");
            cache1.put((Object)"key3", (Object)"value3");
            Cache cache2 = cacheManager2.getCache("cache1");
            cache2.put((Object)"key4", (Object)"value4");
            cache2.put((Object)"key5", (Object)"value5");
            cache2.put((Object)"key6", (Object)"value6");
            cache2.put((Object)"key7", (Object)"value7");
            cache2.put((Object)"key8", (Object)"value8");
            des = new DefaultExecutorService(cache1);
            DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new FailOnlyOnceDistributedCallable()));
            taskBuilder.failoverPolicy(new DistributedTaskFailoverPolicy(){

                public Address failover(FailoverContext context) {
                    List candidates = context.executionCandidates();
                    Address returnAddress = null;
                    for (Address candidate : candidates) {
                        if (candidate.equals(context.executionFailureLocation())) continue;
                        returnAddress = candidate;
                        break;
                    }
                    return returnAddress;
                }

                public int maxFailoverAttempts() {
                    return 1;
                }
            });
            DistributedTask task = taskBuilder.build();
            AssertJUnit.assertEquals((int)1, (int)task.getTaskFailoverPolicy().maxFailoverAttempts());
            Future val = des.submit(task, (Object[])new String[]{"key1", "key5"});
            AssertJUnit.assertEquals((Object)new Boolean(true), val.get());
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager1);
            TestingUtil.killCacheManagers(cacheManager2);
            throw throwable;
        }
        des.shutdownNow();
        TestingUtil.killCacheManagers(cacheManager1);
        TestingUtil.killCacheManagers(cacheManager2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableEmptyFailoverPolicy() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            Cache cache1 = cacheManager.getCache();
            des = new DefaultExecutorService(cache1);
            DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new ExceptionThrowingCallable());
            taskBuilder.failoverPolicy(null);
            DistributedTask task = taskBuilder.build();
            assert (task.getTaskFailoverPolicy().equals(DefaultExecutorService.NO_FAILOVER));
            Future f = des.submit(task, new Object[0]);
            f.get();
        }
        catch (ExecutionException e) {
            try {
                AssertJUnit.assertTrue((String)("Wrong exception: " + e), (boolean)(e.getCause() instanceof ArithmeticException));
            }
            catch (Throwable throwable) {
                des.shutdownNow();
                TestingUtil.killCacheManagers(cacheManager);
                throw throwable;
            }
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
        }
        des.shutdownNow();
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableRandomFailoverPolicy() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            try {
                Cache cache1 = cacheManager.getCache();
                cache1.put((Object)"key1", (Object)"value1");
                cache1.put((Object)"key2", (Object)"value2");
                des = new DefaultExecutorService(cache1);
                DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new FailOnlyOnceCallable());
                taskBuilder.failoverPolicy(DefaultExecutorService.RANDOM_NODE_FAILOVER);
                DistributedTask task = taskBuilder.build();
                assert (task.getTaskFailoverPolicy().equals(DefaultExecutorService.RANDOM_NODE_FAILOVER));
                Future val = des.submit(task, (Object[])new String[]{"key1"});
                val.get();
                throw new IllegalStateException("Should have raised exception");
            }
            catch (ExecutionException e) {
                AssertJUnit.assertTrue((String)("Wrong exception: " + e), (boolean)(e.getCause() instanceof IllegalStateException));
                des.shutdownNow();
                TestingUtil.killCacheManagers(cacheManager);
            }
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableRandomFailoverPolicyWith2Nodes() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            try {
                Cache cache1 = cacheManager.getCache();
                cache1.put((Object)"key1", (Object)"value1");
                cache1.put((Object)"key2", (Object)"value2");
                Cache cache2 = cacheManager1.getCache();
                cache2.put((Object)"key3", (Object)"value3");
                des = new DefaultExecutorService(cache1);
                DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new ExceptionThrowingCallable());
                taskBuilder.failoverPolicy(DefaultExecutorService.RANDOM_NODE_FAILOVER);
                DistributedTask task = taskBuilder.build();
                assert (task.getTaskFailoverPolicy().equals(DefaultExecutorService.RANDOM_NODE_FAILOVER));
                Future val = des.submit(task, (Object[])new String[]{"key1"});
                val.get();
                throw new IllegalStateException("Should have thrown exception");
            }
            catch (Exception e) {
                assert (e instanceof ExecutionException);
                ExecutionException ee = (ExecutionException)e;
                boolean duplicateEEInChain = ee.getCause() instanceof ExecutionException;
                AssertJUnit.assertEquals((boolean)false, (boolean)duplicateEEInChain);
                des.shutdownNow();
                TestingUtil.killCacheManagers(cacheManager, cacheManager1);
            }
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager, cacheManager1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicTargetLocalDistributedCallableWithoutAnyTimeout() throws Exception {
        ConfigurationBuilder confBuilder = BasicDistributedExecutorTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        confBuilder.clustering().sync().replTimeout(0L);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(confBuilder);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(confBuilder);
        Cache cache1 = cacheManager.getCache();
        Cache cache2 = cacheManager1.getCache();
        DefaultExecutorService des = null;
        try {
            des = new DefaultExecutorService(cache1);
            Address target = cache1.getAdvancedCache().getRpcManager().getAddress();
            DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
            Future future = des.submit(target, builder.build());
            AssertJUnit.assertEquals((Object)1, future.get());
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                des.shutdown();
                TestingUtil.killCacheManagers(cacheManager, cacheManager1);
                throw throwable;
            }
            des.shutdown();
            TestingUtil.killCacheManagers(cacheManager, cacheManager1);
        }
        des.shutdown();
        TestingUtil.killCacheManagers(cacheManager, cacheManager1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicTargetRemoteDistributedCallableWithoutAnyTimeout() throws Exception {
        ConfigurationBuilder confBuilder = BasicDistributedExecutorTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        confBuilder.clustering().sync().replTimeout(0L);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(confBuilder);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(confBuilder);
        Cache cache1 = cacheManager.getCache();
        Cache cache2 = cacheManager1.getCache();
        DefaultExecutorService des = null;
        try {
            des = new DefaultExecutorService(cache1);
            Address target = cache2.getAdvancedCache().getRpcManager().getAddress();
            DistributedTaskBuilder builder = des.createDistributedTaskBuilder((Callable)new LocalDistributedExecutorTest.SleepingSimpleCallable());
            Future future = des.submit(target, builder.build());
            AssertJUnit.assertEquals((Object)1, future.get());
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                des.shutdown();
                TestingUtil.killCacheManagers(cacheManager, cacheManager1);
                throw throwable;
            }
            des.shutdown();
            TestingUtil.killCacheManagers(cacheManager, cacheManager1);
        }
        des.shutdown();
        TestingUtil.killCacheManagers(cacheManager, cacheManager1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableCustomFailoverPolicy() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        DefaultExecutorService des = null;
        try {
            try {
                Cache cache1 = cacheManager.getCache();
                cache1.put((Object)"key1", (Object)"value1");
                cache1.put((Object)"key2", (Object)"value2");
                des = new DefaultExecutorService(cache1);
                DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new FailOnlyOnceCallable());
                taskBuilder.failoverPolicy(new DistributedTaskFailoverPolicy(){

                    public Address failover(FailoverContext context) {
                        return context.executionFailureLocation();
                    }

                    public int maxFailoverAttempts() {
                        return 0;
                    }
                });
                DistributedTask task = taskBuilder.build();
                assert (task.getTaskFailoverPolicy().maxFailoverAttempts() == 0);
                Future val = des.submit(task, (Object[])new String[]{"key1"});
                val.get();
                throw new IllegalStateException("Should have thrown exception");
            }
            catch (Exception e) {
                assert (e instanceof ExecutionException);
                ExecutionException ee = (ExecutionException)e;
                boolean duplicateEEInChain = ee.getCause() instanceof ExecutionException;
                AssertJUnit.assertEquals((boolean)false, (boolean)duplicateEEInChain);
                des.shutdownNow();
                TestingUtil.killCacheManagers(cacheManager);
            }
        }
        catch (Throwable throwable) {
            des.shutdownNow();
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
    }

    static class ExceptionThrowingCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        @Override
        public Integer call() throws Exception {
            int a = 5 / 0;
            return 1;
        }
    }

    static class FailOnlyOnceDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 5375461422884389555L;
        private static boolean throwException = true;

        FailOnlyOnceDistributedCallable() {
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
        }

        public Boolean call() throws Exception {
            if (throwException) {
                throwException = false;
                int n = 5 / 0;
            }
            return true;
        }
    }

    static class FailOnlyOnceCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = 3961940091247573385L;
        boolean throwException = true;

        @Override
        public Integer call() throws Exception {
            if (this.throwException) {
                this.throwException = false;
                int n = 5 / 0;
            }
            return 1;
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

