/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.LocalDistributedExecutorTest")
public class LocalDistributedExecutorTest
extends MultipleCacheManagersTest {
    private DistributedExecutorService cleanupService;
    private static final Map<String, AtomicInteger> counterMap = new ConcurrentHashMap<String, AtomicInteger>();

    public LocalDistributedExecutorTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected CacheMode getCacheMode() {
        return CacheMode.LOCAL;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = LocalDistributedExecutorTest.getDefaultClusteredCacheConfig(this.getCacheMode(), false);
        this.createClusteredCaches(1, this.cacheName(), builder);
    }

    @AfterMethod
    public void shutDownDistributedExecutorService() {
        if (this.cleanupService != null) {
            this.cleanupService.shutdown();
        } else {
            this.log.warn((Object)"Should have shutdown DistributedExecutorService but none was set");
        }
    }

    protected String cacheName() {
        return "LocalDistributedExecutorTest";
    }

    protected Cache<Object, Object> getCache() {
        return this.cache(0, this.cacheName());
    }

    public void testBasicInvocation() throws Exception {
        this.basicInvocation(new SimpleCallable());
    }

    @Test(enabled=false)
    public void basicInvocation(Callable<Integer> call) throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit(call);
        Integer r = (Integer)future.get();
        assert (r == 1);
    }

    protected DistributedExecutorService createDES(Cache<?, ?> cache) {
        DefaultExecutorService des = new DefaultExecutorService(cache);
        this.cleanupService = des;
        return des;
    }

    public void testExceptionInvocation() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)new ExceptionThrowingCallable());
        int exceptionCount = 0;
        try {
            future.get();
            throw new IllegalStateException("Should not have reached this code");
        }
        catch (ExecutionException ex) {
            assert (++exceptionCount == 1);
            List list = des.submitEverywhere((Callable)new ExceptionThrowingCallable());
            exceptionCount = 0;
            for (Future f : list) {
                try {
                    f.get();
                    throw new IllegalStateException("Should not have reached this code");
                }
                catch (ExecutionException ex2) {
                    ++exceptionCount;
                }
            }
            assert (exceptionCount == list.size());
            return;
        }
    }

    public void testRunnableInvocation() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Runnable)new BoringRunnable());
        Object object = future.get();
        assert (object == null);
    }

    public void testRunnableInvocationWith2Params() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Integer result = 5;
        Future future = des.submit((Runnable)new BoringRunnable(), (Object)result);
        Integer object = (Integer)future.get();
        assert (object == result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunnableExecution() throws InterruptedException {
        final String uuid = UUID.randomUUID().toString();
        try {
            DistributedExecutorService des = this.createDES(this.getCache());
            BoringRunnable runnable = new BoringRunnable(uuid);
            des.execute((Runnable)runnable);
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return counterMap.get(uuid) != null && ((AtomicInteger)counterMap.get(uuid)).get() >= 1;
                }
            });
        }
        finally {
            counterMap.remove(uuid);
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNonSerializableRunnableExecution() {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.execute(new Runnable(){

            @Override
            public void run() {
                System.out.println("Non Serializable Runnable");
            }
        });
    }

    @Test(expectedExceptions={RejectedExecutionException.class})
    public void testRunnableExecutionOnTerminatedExecutor() {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.shutdown();
        BoringRunnable runnable = new BoringRunnable();
        des.execute((Runnable)runnable);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullRunnableExecution() {
        DistributedExecutorService des = this.createDES(this.getCache());
        Runnable runnable = null;
        des.execute(runnable);
    }

    public void testInvokeAny() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<SimpleCallable> tasks = new ArrayList<SimpleCallable>();
        tasks.add(new SimpleCallable());
        Integer result = (Integer)des.invokeAny(tasks);
        assert (result == 1);
        tasks = new ArrayList();
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        result = (Integer)des.invokeAny(tasks);
        assert (result == 1);
    }

    public void testInvokeAnyWithTimeout() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<SimpleCallable> tasks = new ArrayList<SimpleCallable>();
        tasks.add(new SimpleCallable());
        Integer result = (Integer)des.invokeAny(tasks, 1000L, TimeUnit.MILLISECONDS);
        assert (result == 1);
        tasks = new ArrayList();
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        result = (Integer)des.invokeAny(tasks, 1000L, TimeUnit.MILLISECONDS);
        assert (result == 1);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testInvokeAnyNoTask() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.invokeAny(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvokeAnyEmptyTasks() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.invokeAny(new ArrayList());
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testInvokeAnyExceptionTasks() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<ExceptionThrowingCallable> tasks = new ArrayList<ExceptionThrowingCallable>();
        tasks.add(new ExceptionThrowingCallable());
        tasks.add(new ExceptionThrowingCallable());
        des.invokeAny(tasks);
    }

    public void testInvokeAnySleepingTasks() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
        tasks.add(new ExceptionThrowingCallable());
        tasks.add(new SleepingSimpleCallable());
        Object result = des.invokeAny(tasks);
        assert ((Integer)result == 1);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testInvokeAnyTimedSleepingTasks() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<SleepingSimpleCallable> tasks = new ArrayList<SleepingSimpleCallable>();
        tasks.add(new SleepingSimpleCallable());
        des.invokeAny(tasks, 1000L, TimeUnit.MILLISECONDS);
    }

    public void testInvokeAll() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        ArrayList<SimpleCallable> tasks = new ArrayList<SimpleCallable>();
        tasks.add(new SimpleCallable());
        List list = des.invokeAll(tasks);
        assert (list.size() == 1);
        Future future = (Future)list.get(0);
        assert ((Integer)future.get() == 1);
        tasks = new ArrayList();
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        tasks.add(new SimpleCallable());
        list = des.invokeAll(tasks);
        assert (list.size() == 3);
        for (Future f : list) {
            assert ((Integer)f.get() == 1);
        }
    }

    public void testCallableIsolation() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        List list = des.submitEverywhere((Callable)new SimpleCallableWithField());
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert ((Integer)f.get() == 0);
        }
    }

    public void testBasicDistributedCallable() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(false)));
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(false)));
        DistributedTask distributedTask = taskBuilder.build();
        future = des.submit(distributedTask, new Object[0]);
        r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    public void testSleepingCallableWithTimeoutOption() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)new SleepingSimpleCallable());
        Integer r = (Integer)future.get(20L, TimeUnit.SECONDS);
        assert (r == 1);
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new SleepingSimpleCallable());
        DistributedTask distributedTask = taskBuilder.build();
        future = des.submit(distributedTask, new Object[0]);
        r = (Integer)future.get(20L, TimeUnit.SECONDS);
        assert (r == 1);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testSleepingCallableWithTimeoutExc() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)new SleepingSimpleCallable());
        future.get(2000L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testSleepingCallableWithTimeoutExcDistApi() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new SleepingSimpleCallable());
        DistributedTask distributedTask = taskBuilder.build();
        Future future = des.submit(distributedTask, new Object[0]);
        future.get(2000L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testExceptionCallableWithTimedCall() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)new ExceptionThrowingCallable(true));
        future.get(10L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testExceptionCallableWithTimedCallDistApi() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)new ExceptionThrowingCallable(true));
        DistributedTask distributedTask = taskBuilder.build();
        Future future = des.submit(distributedTask, new Object[0]);
        future.get(10L, TimeUnit.MILLISECONDS);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBasicTargetDistributedCallableWithNullExecutionPolicy() throws Exception {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(false)));
        taskBuilder.executionPolicy(null);
        DistributedTask distributedTask = taskBuilder.build();
        Future future = des.submit(distributedTask, new Object[0]);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicTargetCallableWithNullTarget() {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        des.submit((Address)null, (Callable)new SimpleCallable());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBasicTargetCallableWithIllegalTarget() {
        Cache<Object, Object> cache1 = this.getCache();
        DistributedExecutorService des = this.createDES(cache1);
        Address fakeAddress = new Address(){

            public int compareTo(Address o) {
                return -1;
            }
        };
        des.submit(fakeAddress, (Callable)new SimpleCallable());
    }

    public void testBasicDistributedCallableWitkKeys() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        c1.put((Object)"key1", (Object)"Manik");
        c1.put((Object)"key2", (Object)"Mircea");
        c1.put((Object)"key3", (Object)"Galder");
        c1.put((Object)"key4", (Object)"Sanne");
        DistributedExecutorService des = this.createDES(this.getCache());
        Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        Boolean r = (Boolean)future.get();
        assert (r.booleanValue());
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(true)));
        DistributedTask distributedTask = taskBuilder.build();
        future = des.submit(distributedTask, (Object[])new String[]{"key1", "key2"});
        r = (Boolean)future.get();
        assert (r.booleanValue());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicDistributedCallableWithNullTask() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        DistributedExecutorService des = this.createDES(this.getCache());
        des.submit((DistributedTask)null, (Object[])new String[]{"key1", "key2"});
    }

    public void testBasicDistributedCallableWithNullKeys() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        c1.put((Object)"key1", (Object)"value1");
        c1.put((Object)"key2", (Object)"value2");
        c1.put((Object)"key3", (Object)"value3");
        c1.put((Object)"key4", (Object)"value4");
        DistributedExecutorService des = this.createDES(this.getCache());
        des.submit((Callable)((Object)new SimpleDistributedCallable(false)), null);
    }

    public void testDistributedCallableEverywhereWithKeys() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        c1.put((Object)"key1", (Object)"Manik");
        c1.put((Object)"key2", (Object)"Mircea");
        c1.put((Object)"key3", (Object)"Galder");
        c1.put((Object)"key4", (Object)"Sanne");
        DistributedExecutorService des = this.createDES(this.getCache());
        List list = des.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(true)));
        DistributedTask distributedTask = taskBuilder.build();
        list = des.submitEverywhere(distributedTask, (Object[])new String[]{"key1", "key2"});
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    public void testDistributedCallableEverywhereWithEmptyKeys() throws Exception {
        Cache<Object, Object> c1 = this.getCache();
        c1.put((Object)"key1", (Object)"Manik");
        c1.put((Object)"key2", (Object)"Mircea");
        c1.put((Object)"key3", (Object)"Galder");
        c1.put((Object)"key4", (Object)"Sanne");
        DistributedExecutorService des = this.createDES(this.getCache());
        List list = des.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(false)), (Object[])new String[0]);
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(false)));
        DistributedTask distributedTask = taskBuilder.build();
        list = des.submitEverywhere(distributedTask, (Object[])new String[0]);
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicDistributedCallableEverywhereWithKeysAndNullTask() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.submitEverywhere((DistributedTask)null, (Object[])new String[]{"key1", "key2"});
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicDistributedCallableEverywhereWithNullTask() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        des.submitEverywhere((DistributedTask)null);
    }

    public void testDistributedCallableEverywhere() throws Exception {
        DistributedExecutorService des = this.createDES(this.getCache());
        List list = des.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(false)));
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new SimpleDistributedCallable(false)));
        DistributedTask distributedTask = taskBuilder.build();
        list = des.submitEverywhere(distributedTask);
        assert (list != null && !list.isEmpty());
        for (Future f : list) {
            assert (((Boolean)f.get()).booleanValue());
        }
    }

    static class BoringRunnable
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 6898519516955822402L;
        private String uuid;

        public BoringRunnable() {
        }

        public BoringRunnable(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public void run() {
            System.out.println("I am a boring runnable!");
            if (this.uuid != null) {
                AtomicInteger counter = (AtomicInteger)counterMap.get(this.uuid);
                if (counter == null) {
                    counter = new AtomicInteger();
                    counterMap.put(this.uuid, counter);
                }
                counter.incrementAndGet();
            }
        }
    }

    static class ExceptionThrowingCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8682463816319507893L;
        private boolean needToSleep;

        public ExceptionThrowingCallable() {
            this.needToSleep = false;
        }

        public ExceptionThrowingCallable(boolean needToSleep) {
            this.needToSleep = needToSleep;
        }

        @Override
        public Integer call() throws Exception {
            if (this.needToSleep) {
                Thread.sleep(10000L);
            }
            throw new Exception("Intentional Exception from ExceptionThrowingCallable");
        }
    }

    static class SimpleCallableWithField
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -6262148927734766558L;
        private int count;

        SimpleCallableWithField() {
        }

        @Override
        public Integer call() throws Exception {
            return this.count++;
        }
    }

    static class SleepingSimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        SleepingSimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            Thread.sleep(10000L);
            return 1;
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        SimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

