/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.mapreduce.BaseWordCountMapReduceTest;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceManagerImpl;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.SimpleTwoNodesMapReduceTest")
public class SimpleTwoNodesMapReduceTest
extends BaseWordCountMapReduceTest {
    private static AtomicInteger counter = null;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = SimpleTwoNodesMapReduceTest.getDefaultClusteredCacheConfig(this.getCacheMode(), true);
        this.createClusteredCaches(2, this.cacheName(), builder);
    }

    @Test(expectedExceptions={CancellationException.class})
    public void testInvokeMapperCancellation() throws Exception {
        counter = new AtomicInteger();
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, new LatchMapper(), new BaseWordCountMapReduceTest.WordCountReducer());
        final Future future = task.executeAsynchronously();
        Future<Boolean> cancelled = this.fork(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                SimpleTwoNodesMapReduceTest.this.eventually(new AbstractInfinispanTest.Condition(){

                    @Override
                    public boolean isSatisfied() throws Exception {
                        return counter.get() >= SimpleTwoNodesMapReduceTest.this.nodeCount();
                    }
                });
                return future.cancel(true);
            }
        });
        boolean mapperCancelled = false;
        Throwable root = null;
        try {
            future.get();
        }
        catch (Exception e) {
            root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            mapperCancelled = root.getClass().equals(RuntimeException.class);
        }
        assert (mapperCancelled) : "Mapper not cancelled, root cause " + root;
        assert (cancelled.get().booleanValue());
        assert (future.isDone());
        boolean canceled = future.cancel(true);
        assert (!canceled);
        future.get();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvokeMapReduceNullMapper() throws Exception {
        this.invokeMapReduce(null, null, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvokeMapReduceNullReducer() throws Exception {
        this.invokeMapReduce(null, new ExceptionMapper(false), null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvokeMapReduceNullCombiner() throws Exception {
        Cache cacheObj = this.cache(0, this.cacheName());
        MapReduceTask task = new MapReduceTask(cacheObj);
        MapReduceTask task1 = new MapReduceTask(cacheObj);
        task.mappedWith((Mapper)new ExceptionMapper(false)).reducedWith((Reducer)new ExceptionReducer(false));
        task.combinedWith(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvokeMapReduceWithNullMasterCache() {
        this.createMapReduceTask(null);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testInvokeMapReduceWithException() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, new ExceptionMapper(true), new ExceptionReducer(false));
        task.execute();
    }

    @Test(expectedExceptions={CacheException.class})
    public void testInvokeMapWithReduceExceptionPhaseInLocalExecution() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        cache1.put((Object)"key1", (Object)"value1");
        cache2.put((Object)"key2", (Object)"valu2");
        cache2.put((Object)"key3", (Object)"valu2");
        cache2.put((Object)"key4", (Object)"valu2");
        cache2.put((Object)"key5", (Object)"valu2");
        MapReduceTask task = new MapReduceTask(cache1, true, false);
        task.mappedWith((Mapper)new BaseWordCountMapReduceTest.WordCountMapper()).reducedWith((Reducer)new ExceptionReducer(true));
        Map val = task.execute();
    }

    @Test(expectedExceptions={CacheException.class})
    public void testInvokeMapWithReduceExceptionPhaseInRemoteExecution() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        cache1.put((Object)"key1", (Object)"value1");
        cache2.put((Object)"key2", (Object)"valu2");
        cache2.put((Object)"key3", (Object)"valu2");
        cache2.put((Object)"key4", (Object)"valu2");
        cache2.put((Object)"key5", (Object)"valu2");
        MapReduceTask task = new MapReduceTask(cache1, true, false);
        task.mappedWith((Mapper)new BaseWordCountMapReduceTest.WordCountMapper()).reducedWith((Reducer)new FailAfterSecondCallReducer());
        Map val = task.execute();
    }

    public void testMapReduceTasksComparison() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, new ExceptionMapper(false), new ExceptionReducer(false));
        MapReduceTask<String, String, String, Integer> task1 = this.invokeMapReduce(null, new ExceptionMapper(false), new ExceptionReducer(false));
        MapReduceTask<String, String, String, Integer> task2 = this.invokeMapReduce(null, new ExceptionMapper(false), new ExceptionReducer(false));
        Object task3 = null;
        MapReduceTask<String, String, String, Integer> task4 = task1;
        Object objectForCompare = new Object();
        HashMap<MapReduceTask<String, String, String, Integer>, Integer> taskMap = new HashMap<MapReduceTask<String, String, String, Integer>, Integer>();
        taskMap.put(task, 1);
        taskMap.put(task1, 2);
        assert (taskMap.get(task) != null);
        assert (taskMap.get(task1) != null);
        assert (taskMap.get(task2) == null);
        assert (!task1.equals(task2));
        assert (!task1.equals(task3));
        assert (!task1.equals(objectForCompare));
        assert (task1.equals(task4));
        Pattern p = Pattern.compile("MapReduceTask \\[mapper=\\S+, reducer=\\S+, combiner=\\S*, keys=\\S*, taskId=\\S+\\]");
        Matcher m = p.matcher(task1.toString());
        System.out.println(task1.toString());
        assert (m.find());
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testInvokeAsynchronouslyWithException() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, new ExceptionMapper(true), new ExceptionReducer(true));
        Future futureMap = task.executeAsynchronously();
        Map resultMap = (Map)futureMap.get();
    }

    @Test(expectedExceptions={ExecutionException.class})
    public void testInvokeAsynchronouslyWithCollatorAndException() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, new ExceptionMapper(true), new ExceptionReducer(true));
        Future futureMap = task.executeAsynchronously((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                return 0;
            }
        });
        futureMap.get();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testEnsureProperCacheState() throws Exception {
        ConfigurationBuilder builder = SimpleTwoNodesMapReduceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(builder);
        Cache cache = cacheManager.getCache();
        cache.stop();
        try {
            MapReduceTask<String, String, String, Integer> task = this.createMapReduceTask(cache);
        }
        catch (IllegalStateException ex) {
            try {
                assert (ex.getMessage() != null && ex.getMessage().contains("Invalid cache state"));
                throw ex;
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(cacheManager);
                throw throwable;
            }
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testEnsureProperCacheStateMode() {
        ConfigurationBuilder builder = SimpleTwoNodesMapReduceTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, true);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(builder)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                MapReduceTask task = new MapReduceTask(cache);
            }
        });
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCombinerWithException() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        task.combinedWith((Reducer)new ExceptionReducer(true));
        task.execute();
    }

    public void testIntermediateCompositeKeys() {
        MapReduceManagerImpl.IntermediateCompositeKey key = new MapReduceManagerImpl.IntermediateCompositeKey("task1", (Object)1);
        MapReduceManagerImpl.IntermediateCompositeKey key1 = new MapReduceManagerImpl.IntermediateCompositeKey("task2", (Object)2);
        MapReduceManagerImpl.IntermediateCompositeKey key2 = new MapReduceManagerImpl.IntermediateCompositeKey("task1", (Object)1);
        MapReduceManagerImpl.IntermediateCompositeKey key3 = new MapReduceManagerImpl.IntermediateCompositeKey(null, (Object)1);
        MapReduceManagerImpl.IntermediateCompositeKey key4 = new MapReduceManagerImpl.IntermediateCompositeKey(null, (Object)2);
        MapReduceManagerImpl.IntermediateCompositeKey key5 = new MapReduceManagerImpl.IntermediateCompositeKey("task3", null);
        MapReduceManagerImpl.IntermediateCompositeKey key6 = new MapReduceManagerImpl.IntermediateCompositeKey("task4", null);
        MapReduceManagerImpl.IntermediateCompositeKey key7 = new MapReduceManagerImpl.IntermediateCompositeKey(null, null);
        MapReduceManagerImpl.IntermediateCompositeKey key8 = new MapReduceManagerImpl.IntermediateCompositeKey(null, null);
        assert (!key.equals((Object)key1));
        assert (key.equals((Object)key2));
        assert (!key.equals(null));
        assert (!key.equals((Object)new String()));
        assert (!key3.equals((Object)key4));
        assert (!key5.equals((Object)key6));
        assert (key7.equals((Object)key8));
        assert (!key3.equals((Object)key));
        assert (!key5.equals((Object)key));
    }

    private static class FailAfterSecondCallReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;
        private static int counter;

        private FailAfterSecondCallReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            if (counter > 0) {
                int n = 4 / 0;
            }
            ++counter;
            return 0;
        }
    }

    private static class ExceptionReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;
        private boolean throwException;

        public ExceptionReducer(boolean throwException) {
            this.throwException = throwException;
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            if (this.throwException) {
                int n = 4 / 0;
            }
            return 0;
        }
    }

    private static class ExceptionMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = -5943370243108735560L;
        private boolean throwException = false;

        public ExceptionMapper(boolean throwException) {
            this.throwException = throwException;
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            if (value == null) {
                throw new IllegalArgumentException("Key " + key + " has value " + value);
            }
            if (this.throwException) {
                int a = 4 / 0;
            }
        }
    }

    static class LatchMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = 2518908878377582179L;

        LatchMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            boolean interrupted = false;
            CountDownLatch latch = new CountDownLatch(1);
            try {
                if (!interrupted) {
                    counter.incrementAndGet();
                    latch.await(5000L, TimeUnit.MILLISECONDS);
                } else {
                    interrupted = true;
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                Thread.currentThread().interrupt();
            }
            if (interrupted) {
                throw new RuntimeException();
            }
        }
    }
}

