/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BlockingInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(BlockingInterceptor.class);
    private final CyclicBarrier barrier;
    private final AtomicBoolean firstBlocked = new AtomicBoolean();
    private final Class<? extends VisitableCommand> commandClass;
    private final boolean blockAfter;

    public BlockingInterceptor(CyclicBarrier barrier, Class<? extends VisitableCommand> commandClass, boolean blockAfter) {
        this.barrier = barrier;
        this.commandClass = commandClass;
        this.blockAfter = blockAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockIfNeeded(VisitableCommand command) throws BrokenBarrierException, InterruptedException {
        if (this.commandClass.isInstance(command)) {
            if (this.firstBlocked.compareAndSet(false, true)) {
                try {
                    log.tracef("Command blocking %s completion of %s", (Object)(this.blockAfter ? "after" : "before"), (Object)command);
                    this.barrier.await();
                    this.barrier.await();
                    log.tracef("Command completed blocking completion of %s", (Object)command);
                }
                finally {
                    this.firstBlocked.set(false);
                }
            } else {
                log.trace((Object)"Command arrived but already found a blocker");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            if (!this.blockAfter) {
                this.blockIfNeeded(command);
            }
            Object object = super.handleDefault(ctx, command);
            return object;
        }
        finally {
            if (this.blockAfter) {
                this.blockIfNeeded(command);
            }
        }
    }
}

