/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DisabledL1WithRetValsTest")
public class DisabledL1WithRetValsTest
extends BaseDistFunctionalTest {
    public DisabledL1WithRetValsTest() {
        this.l1CacheEnabled = false;
        this.testRetVals = true;
        this.numOwners = 1;
        this.INIT_CLUSTER_SIZE = 2;
    }

    public void testReplaceFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        Object retval = nonOwner.replace((Object)"k1", (Object)"value2");
        assert ("value".equals(retval));
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testConditionalReplaceFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        boolean success = nonOwner.replace((Object)"k1", (Object)"blah", (Object)"value2");
        assert (!success);
        this.assertOnAllCachesAndOwnership("k1", "value");
        success = nonOwner.replace((Object)"k1", (Object)"value", (Object)"value2");
        assert (success);
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testPutFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        Object retval = nonOwner.put((Object)"k1", (Object)"value2");
        assert ("value".equals(retval));
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testRemoveFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        Object retval = nonOwner.remove((Object)"k1");
        assert ("value".equals(retval));
        this.assertRemovedOnAllCaches("k1");
    }

    public void testConditionalRemoveFromNonOwner() {
        this.initAndTest();
        Cache<Object, String> nonOwner = this.getFirstNonOwner("k1");
        boolean removed = nonOwner.remove((Object)"k1", (Object)"blah");
        assert (!removed);
        this.assertOnAllCachesAndOwnership("k1", "value");
        removed = nonOwner.remove((Object)"k1", (Object)"value");
        assert (removed);
        this.assertRemovedOnAllCaches("k1");
    }

    public void testPutIfAbsentFromNonOwner() {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        assert ("value".equals(retval));
        this.assertOnAllCachesAndOwnership("k1", "value");
        this.c1.clear();
        AssertJUnit.assertFalse((boolean)this.c1.getAdvancedCache().getLockManager().isLocked((Object)"k1"));
        AssertJUnit.assertFalse((boolean)this.c2.getAdvancedCache().getLockManager().isLocked((Object)"k1"));
        retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        assert (null == retval);
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }
}

