/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncTxCommitDiffThreadTest")
public class DistSyncTxCommitDiffThreadTest
extends BaseDistFunctionalTest {
    public DistSyncTxCommitDiffThreadTest() {
        this.cacheName = this.getClass().getSimpleName();
        this.INIT_CLUSTER_SIZE = 2;
        this.sync = true;
        this.tx = true;
        this.l1CacheEnabled = false;
        this.numOwners = 1;
    }

    public void testCommitInDifferentThread(Method m) throws Exception {
        final String key = TestingUtil.k(m);
        final String value = TestingUtil.v(m);
        Cache<Object, String> nonOwnerCache = this.getNonOwners(key, 1)[0];
        final Cache<Object, String> ownerCache = this.getOwners(key, 1)[0];
        final TransactionManager tmNonOwner = this.getTransactionManager(nonOwnerCache);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        tmNonOwner.begin();
        final Transaction tx = tmNonOwner.getTransaction();
        Callable<Void> commitCallable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                tmNonOwner.resume(tx);
                commitLatch.await();
                tmNonOwner.commit();
                return null;
            }
        };
        Future<Void> commitFuture = this.fork(commitCallable);
        Thread.sleep(500L);
        nonOwnerCache.put((Object)key, (Object)value);
        commitLatch.countDown();
        commitFuture.get();
        Callable<Void> getCallable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TransactionManager tmOwner = DistSyncTxCommitDiffThreadTest.this.getTransactionManager(ownerCache);
                tmOwner.begin();
                AssertJUnit.assertEquals((Object)value, (Object)ownerCache.get((Object)key));
                tmOwner.commit();
                return null;
            }
        };
        Future<Void> getFuture = this.fork(getCallable);
        getFuture.get();
    }
}

