/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributionTestHelper {
    public static String safeType(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getSimpleName();
    }

    public static void assertIsInL1(Cache<?, ?> cache, Object key) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(key);
        assert (ice != null) : "Entry for key [" + key + "] should be in L1 on cache at [" + DistributionTestHelper.addressOf(cache) + "]!";
        assert (!(ice instanceof ImmortalCacheEntry)) : "Entry for key [" + key + "] should have a lifespan on cache at [" + DistributionTestHelper.addressOf(cache) + "]!";
    }

    public static void assertIsNotInL1(Cache<?, ?> cache, Object key) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(key);
        assert (ice == null) : "Entry for key [" + key + "] should not be in data container at all on cache at [" + DistributionTestHelper.addressOf(cache) + "]!";
    }

    public static void assertIsInContainerImmortal(Cache<?, ?> cache, Object key) {
        String msg;
        Log log = LogFactory.getLog(BaseDistFunctionalTest.class);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(key);
        if (ice == null) {
            msg = "Entry for key [" + key + "] should be in data container on cache at [" + DistributionTestHelper.addressOf(cache) + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
        if (!(ice instanceof ImmortalCacheEntry)) {
            msg = "Entry for key [" + key + "] on cache at [" + DistributionTestHelper.addressOf(cache) + "] should be immortal but was [" + ice + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
    }

    public static void assertIsInL1OrNull(Cache<?, ?> cache, Object key) {
        Log log = LogFactory.getLog(BaseDistFunctionalTest.class);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(key);
        if (ice instanceof ImmortalCacheEntry) {
            String msg = "Entry for key [" + key + "] on cache at [" + DistributionTestHelper.addressOf(cache) + "] should be mortal or null but was [" + ice + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
    }

    public static boolean isOwner(Cache<?, ?> c, Object key) {
        DistributionManager dm = c.getAdvancedCache().getDistributionManager();
        if (dm != null) {
            return dm.locate(key).contains(DistributionTestHelper.addressOf(c));
        }
        return TestingUtil.extractComponent(c, ClusteringDependentLogic.class).localNodeIsOwner(key);
    }

    public static boolean isFirstOwner(Cache<?, ?> c, Object key) {
        DistributionManager dm = c.getAdvancedCache().getDistributionManager();
        if (dm != null) {
            return DistributionTestHelper.addressOf(c).equals(dm.getPrimaryLocation(key));
        }
        return TestingUtil.extractComponent(c, ClusteringDependentLogic.class).localNodeIsPrimaryOwner(key);
    }

    public static boolean hasOwners(Object key, Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        ConsistentHash consistentHash = primaryOwner.getAdvancedCache().getComponentRegistry().getStateTransferManager().getCacheTopology().getWriteConsistentHash();
        List ownerAddresses = consistentHash.locateOwners(key);
        if (!DistributionTestHelper.addressOf(primaryOwner).equals(ownerAddresses.get(0))) {
            return false;
        }
        for (Cache<?, ?> backupOwner : backupOwners) {
            if (ownerAddresses.contains(DistributionTestHelper.addressOf(backupOwner))) continue;
            return false;
        }
        return true;
    }

    public static Address addressOf(Cache<?, ?> cache) {
        EmbeddedCacheManager cacheManager = cache.getCacheManager();
        return cacheManager.getAddress();
    }
}

