/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.RemoteGetTest")
public class RemoteGetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(Configuration.CacheMode.DIST_SYNC, 3);
        this.cache(0);
        this.cache(1);
        this.cache(2);
        this.waitForClusterToForm();
    }

    private Cache<MagicKey, String> getCacheForAddress(Address a) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals(a)) continue;
            return c;
        }
        return null;
    }

    private Cache<MagicKey, String> getNonOwner(List<Address> a) {
        for (Cache c : this.caches()) {
            if (a.contains(c.getAdvancedCache().getRpcManager().getAddress())) continue;
            return c;
        }
        return null;
    }

    public void testRemoteGet() {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        Cache c3 = this.cache(2);
        MagicKey k = new MagicKey(c1, c2);
        List owners = c1.getAdvancedCache().getDistributionManager().locate((Object)k);
        assert (owners.size() == 2) : "Key should have 2 owners";
        Cache<MagicKey, String> owner1 = this.getCacheForAddress((Address)owners.get(0));
        assert (owner1 == c1);
        Cache<MagicKey, String> owner2 = this.getCacheForAddress((Address)owners.get(1));
        assert (owner2 == c2);
        Cache<MagicKey, String> nonOwner = this.getNonOwner(owners);
        assert (nonOwner == c3);
        owner1.put((Object)k, (Object)"value");
        assert ("value".equals(nonOwner.get((Object)k)));
    }

    public void testGetOfNonexistentKey() {
        Object v = this.cache(0).get((Object)"__ doesn't exist ___");
        assert (v == null) : "Should get a null response";
    }

    public void testGetOfNonexistentKeyOnOwner() {
        MagicKey mk = new MagicKey("does not exist", this.cache(0));
        Object v = this.cache(0).get((Object)mk);
        assert (v == null) : "Should get a null response";
    }
}

