/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.distribution.NonTxConcurrentDistributionInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.TransactionMode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxPrimaryOwnerLeavingTest")
@CleanupAfterMethod
public class NonTxBackupOwnerBecomingPrimaryOwnerTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "___defaultcache";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testPrimaryOwnerLeavingDuringPut() throws Exception {
        this.doTest(false);
    }

    public void testPrimaryOwnerLeavingDuringPutIfAbsent() throws Exception {
        this.doTest(true);
    }

    private void doTest(final boolean conditional) throws Exception {
        CheckPoint checkPoint = new CheckPoint();
        LocalTopologyManager ltm0 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        int preJoinTopologyId = ltm0.getCacheTopology(CACHE_NAME).getTopologyId();
        final AdvancedCache cache0 = this.advancedCache(0);
        this.addBlockingLocalTopologyManager(this.manager(0), checkPoint, preJoinTopologyId);
        final AdvancedCache cache1 = this.advancedCache(1);
        this.addBlockingLocalTopologyManager(this.manager(1), checkPoint, preJoinTopologyId);
        ConfigurationBuilder c = this.getConfigurationBuilder();
        c.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(c);
        this.addBlockingLocalTopologyManager(this.manager(2), checkPoint, preJoinTopologyId);
        this.log.tracef("Starting the cache on the joiner", new Object[0]);
        final AdvancedCache cache2 = this.advancedCache(2);
        int duringJoinTopologyId = preJoinTopologyId + 1;
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(0));
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(1));
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(2));
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getRpcManager().getMembers().size() == 3 && cache1.getRpcManager().getMembers().size() == 3 && cache2.getRpcManager().getMembers().size() == 3;
            }
        });
        CacheTopology duringJoinTopology = ltm0.getCacheTopology(CACHE_NAME);
        AssertJUnit.assertEquals((int)duringJoinTopologyId, (int)duringJoinTopology.getTopologyId());
        AssertJUnit.assertNotNull((Object)duringJoinTopology.getPendingCH());
        final MagicKey key = this.getKeyForCache2(duringJoinTopology.getPendingCH());
        this.log.tracef("Rebalance started. Found key %s with current owners %s and pending owners %s", (Object)key, (Object)duringJoinTopology.getCurrentCH().locateOwners((Object)key), (Object)duringJoinTopology.getPendingCH().locateOwners((Object)key));
        CyclicBarrier beforeCache1Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor1 = new BlockingInterceptor(beforeCache1Barrier, PutKeyValueCommand.class, false);
        cache1.addInterceptorBefore((CommandInterceptor)blockingInterceptor1, NonTxConcurrentDistributionInterceptor.class);
        CyclicBarrier afterCache2Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor2 = new BlockingInterceptor(afterCache2Barrier, PutKeyValueCommand.class, true);
        cache2.addInterceptorBefore((CommandInterceptor)blockingInterceptor2, StateTransferInterceptor.class);
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return conditional ? cache0.putIfAbsent((Object)key, (Object)"v") : cache0.put((Object)key, (Object)"v");
            }
        });
        afterCache2Barrier.await(10L, TimeUnit.SECONDS);
        afterCache2Barrier.await(10L, TimeUnit.SECONDS);
        int postJoinTopologyId = duringJoinTopologyId + 1;
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(0));
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(1));
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(2));
        TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache1, cache2});
        this.log.tracef("Unblocking the put command on node " + this.address(1), new Object[0]);
        beforeCache1Barrier.await(10L, TimeUnit.SECONDS);
        beforeCache1Barrier.await(10L, TimeUnit.SECONDS);
        CacheTopology postJoinTopology = ltm0.getCacheTopology(CACHE_NAME);
        if (postJoinTopology.getCurrentCH().locateOwners((Object)key).contains(this.address(1))) {
            beforeCache1Barrier.await(10L, TimeUnit.SECONDS);
            beforeCache1Barrier.await(10L, TimeUnit.SECONDS);
        }
        afterCache2Barrier.await(10L, TimeUnit.SECONDS);
        afterCache2Barrier.await(10L, TimeUnit.SECONDS);
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((Object)result);
        this.log.tracef("Put operation is done", new Object[0]);
        AssertJUnit.assertEquals((Object)"v", (Object)cache0.get((Object)key));
        AssertJUnit.assertEquals((Object)"v", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"v", (Object)cache2.get((Object)key));
    }

    private MagicKey getKeyForCache2(ConsistentHash pendingCH) {
        MagicKey key;
        int attemptsLeft = 1000;
        while (!pendingCH.locatePrimaryOwner((Object)(key = new MagicKey("key", this.cache(0)))).equals(this.address(2)) && --attemptsLeft > 0) {
        }
        if (attemptsLeft <= 0) {
            throw new IllegalStateException("Can't find a key that will map to " + this.address(2) + " after rebalance!");
        }
        return key;
    }

    private void addBlockingLocalTopologyManager(final EmbeddedCacheManager manager, final CheckPoint checkPoint, final int currentTopologyId) throws InterruptedException {
        LocalTopologyManager component = TestingUtil.extractGlobalComponent((CacheContainer)manager, LocalTopologyManager.class);
        LocalTopologyManager spyLtm = (LocalTopologyManager)Mockito.spy((Object)component);
        ((LocalTopologyManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                CacheTopology topology = (CacheTopology)invocation.getArguments()[1];
                if (topology.getTopologyId() != currentTopologyId) {
                    checkPoint.trigger("pre_topology_" + topology.getTopologyId() + "_on_" + manager.getAddress());
                    checkPoint.await("allow_topology_" + topology.getTopologyId() + "_on_" + manager.getAddress(), 10L, TimeUnit.SECONDS);
                }
                return invocation.callRealMethod();
            }
        }).when((Object)spyLtm)).handleConsistentHashUpdate((String)Matchers.eq((Object)CACHE_NAME), (CacheTopology)Matchers.any(CacheTopology.class), Matchers.anyInt());
        TestingUtil.extractGlobalComponentRegistry((CacheContainer)manager).registerComponent((Object)spyLtm, LocalTopologyManager.class);
    }
}

