/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.distribution.NonTxConcurrentDistributionInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.TransactionMode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxJoinerBecomingBackupOwnerTest")
@CleanupAfterMethod
public class NonTxJoinerBecomingBackupOwnerTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "___defaultcache";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testBackupOwnerJoiningDuringPut() throws Exception {
        this.doTest(Operation.PUT);
    }

    public void testBackupOwnerJoiningDuringPutIfAbsent() throws Exception {
        this.doTest(Operation.PUT_IF_ABSENT);
    }

    public void testBackupOwnerJoiningDuringReplace() throws Exception {
        this.doTest(Operation.REPLACE);
    }

    public void testBackupOwnerJoiningDuringReplaceWithPreviousValue() throws Exception {
        this.doTest(Operation.REPLACE_EXACT);
    }

    public void testBackupOwnerJoiningDuringRemove() throws Exception {
        this.doTest(Operation.REMOVE);
    }

    public void testBackupOwnerJoiningDuringRemoveWithPreviousValue() throws Exception {
        this.doTest(Operation.REMOVE_EXACT);
    }

    private void doTest(final Operation op) throws Exception {
        CheckPoint checkPoint = new CheckPoint();
        LocalTopologyManager ltm0 = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), LocalTopologyManager.class);
        int preJoinTopologyId = ltm0.getCacheTopology(CACHE_NAME).getTopologyId();
        final AdvancedCache cache0 = this.advancedCache(0);
        this.addBlockingLocalTopologyManager(this.manager(0), checkPoint, preJoinTopologyId);
        final AdvancedCache cache1 = this.advancedCache(1);
        this.addBlockingLocalTopologyManager(this.manager(1), checkPoint, preJoinTopologyId);
        ConfigurationBuilder c = this.getConfigurationBuilder();
        c.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(c);
        this.addBlockingLocalTopologyManager(this.manager(2), checkPoint, preJoinTopologyId);
        this.log.tracef("Starting the cache on the joiner", new Object[0]);
        final AdvancedCache cache2 = this.advancedCache(2);
        int duringJoinTopologyId = preJoinTopologyId + 1;
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(0));
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(1));
        checkPoint.trigger("allow_topology_" + duringJoinTopologyId + "_on_" + this.address(2));
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getRpcManager().getMembers().size() == 3 && cache1.getRpcManager().getMembers().size() == 3 && cache2.getRpcManager().getMembers().size() == 3;
            }
        });
        CyclicBarrier beforeCache0Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor0 = new BlockingInterceptor(beforeCache0Barrier, GetKeyValueCommand.class, false);
        cache0.addInterceptorBefore((CommandInterceptor)blockingInterceptor0, StateTransferInterceptor.class);
        CyclicBarrier afterCache1Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor1 = new BlockingInterceptor(afterCache1Barrier, op.getCommandClass(), false);
        cache1.addInterceptorBefore((CommandInterceptor)blockingInterceptor1, StateTransferInterceptor.class);
        CyclicBarrier beforeCache2Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor2 = new BlockingInterceptor(beforeCache2Barrier, op.getCommandClass(), true);
        cache2.addInterceptorBefore((CommandInterceptor)blockingInterceptor2, NonTxConcurrentDistributionInterceptor.class);
        final MagicKey key = this.getKeyForCache2();
        if (op.getPreviousValue() != null) {
            cache0.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)key, op.getPreviousValue());
            cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)key, op.getPreviousValue());
        }
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                switch (op) {
                    case PUT: {
                        return cache0.put((Object)key, op.getValue());
                    }
                    case PUT_IF_ABSENT: {
                        return cache0.putIfAbsent((Object)key, op.getValue());
                    }
                    case REPLACE: {
                        return cache0.replace((Object)key, op.getValue());
                    }
                    case REPLACE_EXACT: {
                        return cache0.replace((Object)key, op.getPreviousValue(), op.getValue());
                    }
                    case REMOVE: {
                        return cache0.remove((Object)key);
                    }
                    case REMOVE_EXACT: {
                        return cache0.remove((Object)key, op.getPreviousValue());
                    }
                }
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)op));
            }
        });
        afterCache1Barrier.await(10L, TimeUnit.SECONDS);
        afterCache1Barrier.await(10L, TimeUnit.SECONDS);
        beforeCache2Barrier.await(10L, TimeUnit.SECONDS);
        beforeCache2Barrier.await(10L, TimeUnit.SECONDS);
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)result);
        this.log.tracef("%s operation is done", (Object)op);
        cache0.removeInterceptor(BlockingInterceptor.class);
        int postJoinTopologyId = duringJoinTopologyId + 1;
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(0));
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(1));
        checkPoint.trigger("allow_topology_" + postJoinTopologyId + "_on_" + this.address(2));
        TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache1, cache2});
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache0.get((Object)key));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache2.get((Object)key));
    }

    private MagicKey getKeyForCache2() {
        return new MagicKey(this.cache(0), this.cache(1), this.cache(2));
    }

    private void addBlockingLocalTopologyManager(final EmbeddedCacheManager manager, final CheckPoint checkPoint, final int currentTopologyId) throws InterruptedException {
        LocalTopologyManager component = TestingUtil.extractGlobalComponent((CacheContainer)manager, LocalTopologyManager.class);
        LocalTopologyManager spyLtm = (LocalTopologyManager)Mockito.spy((Object)component);
        ((LocalTopologyManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                CacheTopology topology = (CacheTopology)invocation.getArguments()[1];
                if (topology.getTopologyId() != currentTopologyId) {
                    checkPoint.trigger("pre_topology_" + topology.getTopologyId() + "_on_" + manager.getAddress());
                    checkPoint.await("allow_topology_" + topology.getTopologyId() + "_on_" + manager.getAddress(), 10L, TimeUnit.SECONDS);
                }
                Object result = invocation.callRealMethod();
                checkPoint.trigger("post_topology_" + topology.getTopologyId() + "_on_" + manager.getAddress());
                return result;
            }
        }).when((Object)spyLtm)).handleConsistentHashUpdate((String)Matchers.eq((Object)CACHE_NAME), (CacheTopology)Matchers.any(CacheTopology.class), Matchers.anyInt());
        TestingUtil.extractGlobalComponentRegistry((CacheContainer)manager).registerComponent((Object)spyLtm, LocalTopologyManager.class);
    }

    private static enum Operation {
        PUT(PutKeyValueCommand.class, "v1", null, null),
        PUT_IF_ABSENT(PutKeyValueCommand.class, "v1", null, null),
        REPLACE(ReplaceCommand.class, "v1", "v0", "v0"),
        REPLACE_EXACT(ReplaceCommand.class, "v1", "v0", true),
        REMOVE(RemoveCommand.class, null, "v0", "v0"),
        REMOVE_EXACT(RemoveCommand.class, null, "v0", true);

        private final Class<? extends VisitableCommand> commandClass;
        private final Object value;
        private final Object previousValue;
        private final Object returnValue;

        private Operation(Class<? extends VisitableCommand> commandClass, Object value, Object previousValue, Object returnValue) {
            this.commandClass = commandClass;
            this.value = value;
            this.previousValue = previousValue;
            this.returnValue = returnValue;
        }

        private Class<? extends VisitableCommand> getCommandClass() {
            return this.commandClass;
        }

        private Object getValue() {
            return this.value;
        }

        private Object getPreviousValue() {
            return this.previousValue;
        }

        private Object getReturnValue() {
            return this.returnValue;
        }
    }
}

