/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.distribution.NonTxConcurrentDistributionInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxPrimaryOwnerLeavingTest")
@CleanupAfterMethod
public class NonTxOriginatorBecomingPrimaryOwnerTest
extends MultipleCacheManagersTest {
    private static final int NUM_KEYS = 10;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    public void testPrimaryOwnerLeavingDuringPut() throws Exception {
        this.doTest(false);
    }

    public void testPrimaryOwnerLeavingDuringPutIfAbsent() throws Exception {
        this.doTest(true);
    }

    private void doTest(final boolean conditional) throws Exception {
        final AdvancedCache cache0 = this.advancedCache(0);
        AdvancedCache cache1 = this.advancedCache(1);
        AdvancedCache cache2 = this.advancedCache(2);
        CyclicBarrier distInterceptorBarrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor = new BlockingInterceptor(distInterceptorBarrier, PutKeyValueCommand.class, false);
        cache0.addInterceptorBefore((CommandInterceptor)blockingInterceptor, NonTxConcurrentDistributionInterceptor.class);
        for (int i = 0; i < 10; ++i) {
            final MagicKey key = new MagicKey("key" + i, (Cache<?, ?>)cache1);
            Future<Object> future = this.fork(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conditional ? cache0.putIfAbsent((Object)key, (Object)"v") : cache0.put((Object)key, (Object)"v");
                }
            });
            distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
            cache1.stop();
            TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache2});
            distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
            distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
            distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
            if (cache2.getAdvancedCache().getDistributionManager().getPrimaryLocation((Object)key).equals(this.address(2))) {
                distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
                distInterceptorBarrier.await(10L, TimeUnit.SECONDS);
            }
            Object result = future.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNull((Object)result);
            this.log.tracef("Put operation is done", new Object[0]);
            AssertJUnit.assertEquals((Object)"v", (Object)cache0.get((Object)key));
            cache1.start();
            TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache1, cache2});
        }
    }
}

