/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxPrimaryOwnerLeavingTest")
@CleanupAfterMethod
public class NonTxPrimaryOwnerLeavingTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    public void testPrimaryOwnerLeavingDuringPut() throws Exception {
        this.doTest(false);
    }

    public void testPrimaryOwnerLeavingDuringPutIfAbsent() throws Exception {
        this.doTest(true);
    }

    private void doTest(final boolean conditional) throws Exception {
        final AdvancedCache cache0 = this.advancedCache(0);
        AdvancedCache cache1 = this.advancedCache(1);
        ControlledRpcManager crm = new ControlledRpcManager(cache0.getRpcManager());
        cache0.getComponentRegistry().registerComponent((Object)crm, RpcManager.class);
        cache0.getComponentRegistry().rewire();
        crm.blockBefore(PutKeyValueCommand.class);
        final MagicKey key = new MagicKey((Cache<?, ?>)cache1);
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return conditional ? cache0.putIfAbsent((Object)key, (Object)"v") : cache0.put((Object)key, (Object)"v");
            }
        });
        crm.waitForCommandToBlock();
        cache1.stop();
        crm.stopBlocking();
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((Object)result);
        this.log.tracef("Put operation is done", new Object[0]);
        AssertJUnit.assertEquals((Object)"v", (Object)cache0.get((Object)key));
    }
}

