/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="distribution.rehash.NonTxPutIfAbsentDuringJoinStressTest")
@CleanupAfterMethod
public class NonTxPutIfAbsentDuringJoinStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_WRITERS = 4;
    private static final int NUM_ORIGINATORS = 2;
    private static final int NUM_KEYS = 1000;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testNodeJoiningDuringPutIfAbsent() throws Exception {
        int i;
        Future[] futures = new Future[4];
        for (i = 0; i < 4; ++i) {
            final int finalI = i;
            futures[i] = this.fork(new Callable(){

                public Object call() throws Exception {
                    for (int j = 0; j < 1000; ++j) {
                        Cache cache = NonTxPutIfAbsentDuringJoinStressTest.this.cache(finalI % 2);
                        cache.putIfAbsent((Object)("key_" + finalI + "_" + j), (Object)("value_" + finalI + "_" + j));
                    }
                    return null;
                }
            });
        }
        this.addClusterEnabledCacheManager(this.getConfigurationBuilder());
        this.waitForClusterToForm();
        this.addClusterEnabledCacheManager(this.getConfigurationBuilder());
        this.waitForClusterToForm();
        TimeUnit.MILLISECONDS.sleep(4000L);
        for (i = 0; i < 4; ++i) {
            futures[i].get(10L, TimeUnit.SECONDS);
            for (int j = 0; j < 1000; ++j) {
                for (int k = 0; k < this.caches().size(); ++k) {
                    AssertJUnit.assertEquals((Object)this.cache(k).get((Object)("key_" + i + "_" + j)), (Object)("value_" + i + "_" + j));
                }
            }
        }
    }
}

