/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxPutIfAbsentDuringJoinStressTest")
@CleanupAfterMethod
public class NonTxPutIfAbsentDuringLeaveStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_WRITERS = 10;
    private static final int NUM_ORIGINATORS = 2;
    private static final int NUM_KEYS = 200;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testNodeLeavingDuringPutIfAbsent() throws Exception {
        int i;
        Future[] futures = new Future[10];
        for (i = 0; i < 10; ++i) {
            final int finalI = i;
            futures[i] = this.fork(new Callable(){

                public Object call() throws Exception {
                    for (int j = 0; j < 200; ++j) {
                        Cache cache = NonTxPutIfAbsentDuringLeaveStressTest.this.cache(finalI % 2);
                        this.putRetryOnSuspect((Cache<Object, Object>)cache, "key_" + finalI + "_" + j, "value_" + finalI + "_" + j);
                    }
                    return null;
                }

                private void putRetryOnSuspect(Cache<Object, Object> cache, String key, String value) {
                    try {
                        cache.putIfAbsent((Object)key, (Object)value);
                    }
                    catch (SuspectException e) {
                        this.putRetryOnSuspect(cache, key, value);
                    }
                }
            });
        }
        this.killMember(4);
        this.waitForClusterToForm();
        this.killMember(3);
        this.waitForClusterToForm();
        TimeUnit.MILLISECONDS.sleep(2000L);
        for (i = 0; i < 10; ++i) {
            futures[i].get(10L, TimeUnit.SECONDS);
            for (int j = 0; j < 200; ++j) {
                for (int k = 0; k < this.caches().size(); ++k) {
                    AssertJUnit.assertEquals((Object)("value_" + i + "_" + j), (Object)this.cache(k).get((Object)("key_" + i + "_" + j)));
                }
            }
        }
    }
}

