/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.rehash.TestWriteOperation;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxStateTransferOverwritingValue2Test")
public class NonTxStateTransferOverwritingValue2Test
extends MultipleCacheManagersTest {
    public NonTxStateTransferOverwritingValue2Test() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testBackupOwnerJoiningDuringPutOverwrite() throws Exception {
        this.doTest(TestWriteOperation.PUT_OVERWRITE);
    }

    public void testBackupOwnerJoiningDuringReplace() throws Exception {
        this.doTest(TestWriteOperation.REPLACE);
    }

    public void testBackupOwnerJoiningDuringReplaceWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REPLACE_EXACT);
    }

    public void testBackupOwnerJoiningDuringRemove() throws Exception {
        this.doTest(TestWriteOperation.REMOVE);
    }

    public void testBackupOwnerJoiningDuringRemoveWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REMOVE_EXACT);
    }

    private void doTest(final TestWriteOperation op) throws Exception {
        final AdvancedCache cache0 = this.advancedCache(0);
        String key = "key";
        Object previousValue = op.getPreviousValue();
        if (previousValue != null) {
            cache0.put((Object)"key", previousValue);
            AssertJUnit.assertEquals((Object)previousValue, (Object)cache0.get((Object)"key"));
            this.log.tracef("Previous value inserted: %s = %s", (Object)"key", previousValue);
        }
        int preJoinTopologyId = cache0.getComponentRegistry().getStateTransferManager().getCacheTopology().getTopologyId();
        CheckPoint checkPoint = new CheckPoint();
        ControlledRpcManager blockingRpcManager0 = this.blockStateResponseCommand((Cache)cache0);
        this.log.tracef("Starting the cache on the joiner", new Object[0]);
        ConfigurationBuilder c = this.getConfigurationBuilder();
        c.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(c);
        final AdvancedCache cache1 = this.advancedCache(1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getRpcManager().getMembers().size() == 2 && cache1.getRpcManager().getMembers().size() == 2;
            }
        });
        this.blockEntryCommit(checkPoint, cache1);
        blockingRpcManager0.waitForCommandToBlock();
        blockingRpcManager0.stopBlocking();
        checkPoint.awaitStrict("pre_commit_entry_key_from_" + null, 5L, TimeUnit.SECONDS);
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return op.perform((AdvancedCache<Object, Object>)cache0, "key");
            }
        });
        boolean blocked = checkPoint.peek(3L, TimeUnit.SECONDS, "pre_commit_entry_key_from_" + this.address(0)) == null;
        AssertJUnit.assertTrue((boolean)blocked);
        checkPoint.trigger("resume_commit_entry_key_from_" + this.address(0), 2);
        checkPoint.trigger("resume_commit_entry_key_from_" + null);
        checkPoint.awaitStrict("post_commit_entry_key_from_" + null, 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("post_commit_entry_key_from_" + this.address(0), 10L, TimeUnit.SECONDS);
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)result);
        this.log.tracef("%s operation is done", (Object)op);
        TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache1});
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache0.get((Object)"key"));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache1.get((Object)"key"));
    }

    private void blockEntryCommit(final CheckPoint checkPoint, AdvancedCache<Object, Object> cache) {
        ClusteringDependentLogic cdl1 = (ClusteringDependentLogic)cache.getComponentRegistry().getComponent(ClusteringDependentLogic.class);
        ClusteringDependentLogic spyCdl1 = (ClusteringDependentLogic)Mockito.spy((Object)cdl1);
        TestingUtil.replaceComponent(cache, ClusteringDependentLogic.class, spyCdl1, true);
        ((ClusteringDependentLogic)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                CacheEntry entry = (CacheEntry)arguments[0];
                Object key = entry.getKey();
                InvocationContext ctx = (InvocationContext)arguments[3];
                Address source = ctx.getOrigin();
                checkPoint.trigger("pre_commit_entry_" + key + "_from_" + source);
                checkPoint.awaitStrict("resume_commit_entry_" + key + "_from_" + source, 10L, TimeUnit.SECONDS);
                Object result = invocation.callRealMethod();
                checkPoint.trigger("post_commit_entry_" + key + "_from_" + source);
                return result;
            }
        }).when((Object)spyCdl1)).commitEntry((CacheEntry)Matchers.any(CacheEntry.class), (EntryVersion)Matchers.any(EntryVersion.class), Matchers.anyBoolean(), (InvocationContext)Matchers.any(InvocationContext.class));
    }

    private ControlledRpcManager blockStateResponseCommand(Cache cache) throws InterruptedException {
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        ControlledRpcManager controlledRpcManager = new ControlledRpcManager(rpcManager);
        controlledRpcManager.blockBefore(StateResponseCommand.class);
        TestingUtil.replaceComponent(cache, RpcManager.class, controlledRpcManager, true);
        return controlledRpcManager;
    }
}

