/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.rehash.TestWriteOperation;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.NonTxStateTransferOverwritingValueTest")
@CleanupAfterMethod
public class NonTxStateTransferOverwritingValueTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = this.getConfigurationBuilder();
        this.addClusterEnabledCacheManager(c);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return c;
    }

    public void testBackupOwnerJoiningDuringPut() throws Exception {
        this.doTest(TestWriteOperation.PUT_CREATE);
    }

    public void testBackupOwnerJoiningDuringPutOverwrite() throws Exception {
        this.doTest(TestWriteOperation.PUT_OVERWRITE);
    }

    public void testBackupOwnerJoiningDuringPutIfAbsent() throws Exception {
        this.doTest(TestWriteOperation.PUT_IF_ABSENT);
    }

    public void testBackupOwnerJoiningDuringReplace() throws Exception {
        this.doTest(TestWriteOperation.REPLACE);
    }

    public void testBackupOwnerJoiningDuringReplaceWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REPLACE_EXACT);
    }

    public void testBackupOwnerJoiningDuringRemove() throws Exception {
        this.doTest(TestWriteOperation.REMOVE);
    }

    public void testBackupOwnerJoiningDuringRemoveWithPreviousValue() throws Exception {
        this.doTest(TestWriteOperation.REMOVE_EXACT);
    }

    private void doTest(final TestWriteOperation op) throws Exception {
        final AdvancedCache cache0 = this.advancedCache(0);
        String key = "key";
        Object previousValue = op.getPreviousValue();
        if (previousValue != null) {
            cache0.put((Object)"key", previousValue);
            AssertJUnit.assertEquals((Object)previousValue, (Object)cache0.get((Object)"key"));
            this.log.tracef("Previous value inserted: %s = %s", (Object)"key", previousValue);
        }
        int preJoinTopologyId = cache0.getComponentRegistry().getStateTransferManager().getCacheTopology().getTopologyId();
        CheckPoint checkPoint = new CheckPoint();
        ControlledRpcManager blockingRpcManager0 = this.blockStateResponseCommand((Cache)cache0);
        this.blockRebalanceConfirmation(this.manager(0), checkPoint);
        this.log.tracef("Starting the cache on the joiner", new Object[0]);
        ConfigurationBuilder c = this.getConfigurationBuilder();
        c.clustering().stateTransfer().awaitInitialTransfer(false);
        this.addClusterEnabledCacheManager(c);
        final AdvancedCache cache1 = this.advancedCache(1);
        int rebalanceTopologyId = preJoinTopologyId + 1;
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return cache0.getRpcManager().getMembers().size() == 2 && cache1.getRpcManager().getMembers().size() == 2;
            }
        });
        CyclicBarrier beforeCommitCache1Barrier = new CyclicBarrier(2);
        BlockingInterceptor blockingInterceptor1 = new BlockingInterceptor(beforeCommitCache1Barrier, op.getCommandClass(), true);
        cache1.addInterceptorAfter((CommandInterceptor)blockingInterceptor1, EntryWrappingInterceptor.class);
        blockingRpcManager0.waitForCommandToBlock();
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return op.perform((AdvancedCache<Object, Object>)cache0, "key");
            }
        });
        beforeCommitCache1Barrier.await(10L, TimeUnit.SECONDS);
        blockingRpcManager0.stopBlocking();
        checkPoint.awaitStrict("pre_rebalance_confirmation_" + rebalanceTopologyId + "_from_" + this.address(1), 10L, TimeUnit.SECONDS);
        beforeCommitCache1Barrier.await(10L, TimeUnit.SECONDS);
        Object result = future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)op.getReturnValue(), (Object)result);
        this.log.tracef("%s operation is done", (Object)op);
        checkPoint.trigger("resume_rebalance_confirmation_" + rebalanceTopologyId + "_from_" + this.address(0));
        checkPoint.trigger("resume_rebalance_confirmation_" + rebalanceTopologyId + "_from_" + this.address(1));
        TestingUtil.waitForRehashToComplete(new Cache[]{cache0, cache1});
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache0.get((Object)"key"));
        AssertJUnit.assertEquals((Object)op.getValue(), (Object)cache1.get((Object)"key"));
    }

    private ControlledRpcManager blockStateResponseCommand(Cache cache) throws InterruptedException {
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        ControlledRpcManager controlledRpcManager = new ControlledRpcManager(rpcManager);
        controlledRpcManager.blockBefore(StateResponseCommand.class);
        TestingUtil.replaceComponent(cache, RpcManager.class, controlledRpcManager, true);
        return controlledRpcManager;
    }

    private void blockRebalanceConfirmation(EmbeddedCacheManager manager, final CheckPoint checkPoint) throws Exception {
        ClusterTopologyManager ctm = TestingUtil.extractGlobalComponent((CacheContainer)manager, ClusterTopologyManager.class);
        ClusterTopologyManager spyManager = (ClusterTopologyManager)Mockito.spy((Object)ctm);
        ((ClusterTopologyManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                Address source = (Address)arguments[1];
                int topologyId = (Integer)arguments[2];
                checkPoint.trigger("pre_rebalance_confirmation_" + topologyId + "_from_" + source);
                checkPoint.awaitStrict("resume_rebalance_confirmation_" + topologyId + "_from_" + source, 10L, TimeUnit.SECONDS);
                return invocation.callRealMethod();
            }
        }).when((Object)spyManager)).handleRebalanceCompleted(Matchers.anyString(), (Address)Matchers.any(Address.class), Matchers.anyInt(), (Throwable)Matchers.any(Throwable.class), Matchers.anyInt());
        TestingUtil.replaceComponent((CacheContainer)manager, ClusterTopologyManager.class, spyManager, true);
    }
}

