/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.rehash.Updater;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class RehashTestBase
extends BaseDistFunctionalTest {
    protected RehashTestBase() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.tx = true;
        this.performRehashing = true;
    }

    abstract void performRehashEvent(boolean var1) throws Throwable;

    abstract void waitForRehashCompletion();

    void additionalWait() {
        TestingUtil.sleepThread(1000L);
    }

    protected List<MagicKey> init() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey("k1", this.c1), new MagicKey("k2", this.c2), new MagicKey("k3", this.c3), new MagicKey("k4", this.c4)));
        Assert.assertEquals((int)this.caches.size(), (int)keys.size(), (String)("Received caches" + this.caches));
        int i = 0;
        for (Cache c : this.caches) {
            c.put(keys.get(i++), (Object)("v" + i));
        }
        i = 0;
        for (MagicKey key : keys) {
            this.assertOwnershipAndNonOwnership(key, false);
        }
        this.log.infof("Initialized with keys %s", keys);
        return keys;
    }

    @Test
    public void testNonTransactional() throws Throwable {
        List<MagicKey> keys = this.init();
        this.log.info((Object)"Invoking rehash event");
        this.performRehashEvent(false);
        this.waitForRehashCompletion();
        this.log.info((Object)"Rehash complete");
        int i = 0;
        for (MagicKey key : keys) {
            this.assertOnAllCachesAndOwnership(key, "v" + ++i);
        }
    }

    @Test
    public void testTransactional() throws Throwable {
        final List<MagicKey> keys = this.init();
        final CountDownLatch l = new CountDownLatch(1);
        final AtomicBoolean rollback = new AtomicBoolean(false);
        Thread th = new Thread("Updater"){

            @Override
            public void run() {
                try {
                    TransactionManager t1 = TestingUtil.getTransactionManager(RehashTestBase.this.c1);
                    t1.begin();
                    RehashTestBase.this.c1.put(keys.get(0), (Object)"transactionally_replaced");
                    Transaction tx = t1.getTransaction();
                    tx.enlistResource((XAResource)new XAResourceAdapter(){

                        @Override
                        public int prepare(Xid id) {
                            try {
                                l.await();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            return 0;
                        }
                    });
                    t1.commit();
                }
                catch (Exception e) {
                    RehashTestBase.this.log.error((Object)"Error committing transaction", (Throwable)e);
                    rollback.set(true);
                    throw new RuntimeException(e);
                }
            }
        };
        th.start();
        this.log.info((Object)"Invoking rehash event");
        this.performRehashEvent(true);
        l.countDown();
        th.join();
        this.waitForRehashCompletion();
        this.log.info((Object)"Rehash complete");
        if (!rollback.get()) {
            this.assertOwnershipAndNonOwnership(keys.get(0), true);
            this.assertOwnershipAndNonOwnership(keys.get(1), this.l1OnRehash);
            this.assertOwnershipAndNonOwnership(keys.get(2), this.l1OnRehash);
            this.assertOwnershipAndNonOwnership(keys.get(3), this.l1OnRehash);
            this.assertOnAllCaches(keys.get(0), "transactionally_replaced");
            this.assertOnAllCaches(keys.get(1), "v2");
            this.assertOnAllCaches(keys.get(2), "v3");
            this.assertOnAllCaches(keys.get(3), "v4");
        }
    }

    @Test(enabled=false, description="Enable after releasing Beta1")
    public void testNonTransactionalStress() throws Throwable {
        this.stressTest(false);
    }

    @Test(enabled=false, description="Enable after releasing Beta1")
    public void testTransactionalStress() throws Throwable {
        this.stressTest(true);
    }

    private void stressTest(boolean tx) throws Throwable {
        List<MagicKey> keys = this.init();
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Updater> updaters = new ArrayList<Updater>(keys.size());
        for (MagicKey k : keys) {
            Updater u = new Updater(this.c1, k, latch, tx);
            u.start();
            updaters.add(u);
        }
        latch.countDown();
        this.log.info((Object)"Invoking rehash event");
        this.performRehashEvent(false);
        for (Updater u : updaters) {
            u.complete();
        }
        for (Updater u : updaters) {
            u.join();
        }
        this.waitForRehashCompletion();
        this.log.info((Object)"Rehash complete");
        int i = 0;
        for (MagicKey key : keys) {
            this.assertOnAllCachesAndOwnership(key, "v" + ((Updater)updaters.get((int)i++)).currentValue);
        }
    }
}

