/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.RehashWithL1Test")
public class RehashWithL1Test
extends MultipleCacheManagersTest {
    ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builder = RehashWithL1Test.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.builder.clustering().stateTransfer().fetchInMemoryState(true).hash().l1().enable();
        this.createClusteredCaches(2, this.builder);
    }

    public void testPutWithRehashAndCacheClear() throws Exception {
        int i;
        Future<Void> node3Join = null;
        int opCount = 100;
        for (i = 0; i < opCount; ++i) {
            this.cache(0).put((Object)("k" + i), (Object)"some data");
            if (i == opCount / 2) {
                node3Join = this.fork(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        EmbeddedCacheManager cm = RehashWithL1Test.this.addClusterEnabledCacheManager(RehashWithL1Test.this.builder, new TransportFlags().withMerge(true));
                        cm.getCache();
                        return null;
                    }
                });
            }
            Thread.sleep(10L);
        }
        if (node3Join == null) {
            throw new Exception("Node 3 not joined");
        }
        node3Join.get();
        for (i = 0; i < opCount; ++i) {
            this.cache(0).remove((Object)("k" + i));
            Thread.sleep(10L);
        }
        for (i = 0; i < opCount; ++i) {
            String key = "k" + i;
            AssertJUnit.assertFalse((boolean)this.cache(0).containsKey((Object)key));
            AssertJUnit.assertFalse((String)("Key: " + key + " is present in cache at " + this.cache(1)), (boolean)this.cache(1).containsKey((Object)key));
            AssertJUnit.assertFalse((String)("Key: " + key + " is present in cache at " + this.cache(2)), (boolean)this.cache(2).containsKey((Object)key));
        }
        AssertJUnit.assertEquals((int)0, (int)this.cache(0).size());
        AssertJUnit.assertEquals((int)0, (int)this.cache(1).size());
        AssertJUnit.assertEquals((int)0, (int)this.cache(2).size());
    }
}

