/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.List;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareSyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyAwareConsistentHashFactoryTest;
import org.infinispan.distribution.topologyaware.TopologyAwareOwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="topologyaware.TopologyAwareSyncConsistentHashFactoryTest")
public class TopologyAwareSyncConsistentHashFactoryTest
extends TopologyAwareConsistentHashFactoryTest {
    private Log log = LogFactory.getLog(TopologyAwareSyncConsistentHashFactoryTest.class);

    public TopologyAwareSyncConsistentHashFactoryTest() {
        this.numSegments = 1000;
    }

    @Override
    protected ConsistentHashFactory<DefaultConsistentHash> createConsistentHashFactory() {
        return new TopologyAwareSyncConsistentHashFactory();
    }

    @Override
    protected void assertDistribution(int numOwners, List<Address> currentMembers) {
        TopologyAwareOwnershipStatistics stats = new TopologyAwareOwnershipStatistics(this.ch);
        this.log.tracef("Ownership stats: " + stats, new Object[0]);
        int maxPrimarySegments = this.numSegments / currentMembers.size() + 1;
        for (Address node : currentMembers) {
            int maxSegments = stats.computeMaxSegments(this.numSegments, numOwners, node);
            this.log.tracef("Primary segments ratio: %f, total segments ratio: %f", (Object)(stats.getPrimaryOwned(node) / maxPrimarySegments), (Object)(stats.getOwned(node) / maxSegments));
            Assert.assertTrue(((double)maxPrimarySegments * 0.4 <= (double)stats.getPrimaryOwned(node) ? 1 : 0) != 0);
            Assert.assertTrue((stats.getPrimaryOwned(node) <= maxPrimarySegments * 2 ? 1 : 0) != 0);
            Assert.assertTrue(((double)maxSegments * 0.4 <= (double)stats.getOwned(node) ? 1 : 0) != 0);
            Assert.assertTrue((stats.getOwned(node) <= maxSegments * 2 ? 1 : 0) != 0);
        }
    }
}

