/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, enabled=false, testName="profiling.ExpensiveEvictionTest")
public class ExpensiveEvictionTest
extends SingleCacheManagerTest {
    private final Integer MAX_CACHE_ELEMENTS = 10000000;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = new Configuration().fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(this.MAX_CACHE_ELEMENTS).expiration().wakeUpInterval(Long.valueOf(3000L)).build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        return cm;
    }

    public void testSimpleEvictionMaxEntries() throws Exception {
        System.out.println("Max entries: " + this.MAX_CACHE_ELEMENTS);
        for (int i = 0; i < this.MAX_CACHE_ELEMENTS; ++i) {
            Integer integer = i;
            this.cache.put((Object)integer, (Object)integer, 6L, TimeUnit.HOURS);
            if (i % 50000 != 0) continue;
            System.out.println("Elemenents in cache: " + this.cache.size());
        }
        System.out.println("Finished filling in cache. Now idle while eviting thread works....");
        Thread.sleep(TimeUnit.MILLISECONDS.convert(2L, TimeUnit.HOURS));
    }
}

