/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.MarshalledValuesEvictionTest;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.MarshalledValuesManualEvictionTest")
public class MarshalledValuesManualEvictionTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setUseLockStriping(false);
        cfg.setUseLazyDeserialization(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        StreamingMarshaller marshaller = TestingUtil.extractComponent(this.cache, StreamingMarshaller.class);
        MarshalledValuesEvictionTest.MockMarshalledValueInterceptor interceptor = new MarshalledValuesEvictionTest.MockMarshalledValueInterceptor(marshaller);
        assert (TestingUtil.replaceInterceptor(this.cache, (CommandInterceptor)interceptor, MarshalledValueInterceptor.class));
        return cm;
    }

    public void testManualEvictCustomKeyValue() {
        ManualEvictionPojo p1 = new ManualEvictionPojo();
        p1.i = 64;
        ManualEvictionPojo p2 = new ManualEvictionPojo();
        p2.i = 24;
        ManualEvictionPojo p3 = new ManualEvictionPojo();
        p3.i = 97;
        ManualEvictionPojo p4 = new ManualEvictionPojo();
        p4.i = 35;
        this.cache.put((Object)p1, (Object)p2);
        this.cache.put((Object)p3, (Object)p4);
        this.cache.evict((Object)p1);
        MarshalledValuesEvictionTest.MockMarshalledValueInterceptor interceptor = (MarshalledValuesEvictionTest.MockMarshalledValueInterceptor)TestingUtil.findInterceptor(this.cache, MarshalledValueInterceptor.class);
        assert (interceptor.marshalledValueCreated);
    }

    public void testEvictPrimitiveKeyCustomValue() {
        ManualEvictionPojo p1 = new ManualEvictionPojo();
        p1.i = 51;
        ManualEvictionPojo p2 = new ManualEvictionPojo();
        p2.i = 78;
        this.cache.put((Object)"key-isoprene", (Object)p1);
        this.cache.put((Object)"key-hexastyle", (Object)p2);
        this.cache.evict((Object)"key-isoprene");
        MarshalledValuesEvictionTest.MockMarshalledValueInterceptor interceptor = (MarshalledValuesEvictionTest.MockMarshalledValueInterceptor)TestingUtil.findInterceptor(this.cache, MarshalledValueInterceptor.class);
        assert (!interceptor.marshalledValueCreated);
    }

    static class ManualEvictionPojo
    implements Externalizable {
        int i;

        ManualEvictionPojo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManualEvictionPojo pojo = (ManualEvictionPojo)o;
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            return result;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
        }
    }
}

