/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiry;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiry.ExpiryTest")
public class ExpiryTest
extends AbstractInfinispanTest {
    public static final int EXPIRATION_TIMEOUT = 3000;
    public static final int IDLE_TIMEOUT = 3000;
    public static final int EVICTION_CHECK_TIMEOUT = 2000;
    CacheContainer cm;

    @BeforeMethod
    public void setUp() {
        this.cm = TestCacheManagerFactory.createLocalCacheManager(false);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testLifespanExpiryInPut() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long lifespan = 3000L;
        cache.put((Object)"k", (Object)"v", lifespan, TimeUnit.MILLISECONDS);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry se = dc.get((Object)"k");
        assert (se.getKey().equals("k"));
        assert (se.getValue().equals("v"));
        assert (se.getLifespan() == lifespan);
        assert (se.getMaxIdle() == -1L);
        assert (!se.isExpired());
        assert (((String)cache.get((Object)"k")).equals("v"));
        Thread.sleep(lifespan + 100L);
        assert (se.isExpired());
        assert (cache.get((Object)"k") == null);
    }

    public void testIdleExpiryInPut() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long idleTime = 3000L;
        cache.put((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry se = dc.get((Object)"k");
        assert (se.getKey().equals("k"));
        assert (se.getValue().equals("v"));
        assert (se.getLifespan() == -1L);
        assert (se.getMaxIdle() == idleTime);
        assert (!se.isExpired());
        assert (((String)cache.get((Object)"k")).equals("v"));
        Thread.sleep(idleTime + 100L);
        assert (se.isExpired());
        assert (cache.get((Object)"k") == null);
    }

    public void testLifespanExpiryInPutAll() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v");
        m.put("k2", "v");
        cache.putAll(m, 3000L, TimeUnit.MILLISECONDS);
        while (true) {
            String v1 = (String)cache.get((Object)"k1");
            String v2 = (String)cache.get((Object)"k2");
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals((String)"v", (String)v1);
            AssertJUnit.assertEquals((String)"v", (String)v2);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 3000L) {
            if (cache.get((Object)"k1") != null || cache.get((Object)"k2") != null) continue;
            return;
        }
        assert (cache.get((Object)"k1") == null);
        assert (cache.get((Object)"k2") == null);
    }

    public void testIdleExpiryInPutAll() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long idleTime = 3000L;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v");
        m.put("k2", "v");
        cache.putAll(m, -1L, TimeUnit.MILLISECONDS, 3000L, TimeUnit.MILLISECONDS);
        assert (((String)cache.get((Object)"k1")).equals("v"));
        assert (((String)cache.get((Object)"k2")).equals("v"));
        Thread.sleep(3100L);
        assert (cache.get((Object)"k1") == null);
        assert (cache.get((Object)"k2") == null);
    }

    public void testLifespanExpiryInPutIfAbsent() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        assert (cache.putIfAbsent((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) == null);
        long partial = 300L;
        Thread.sleep(3000L - partial);
        assert (((String)cache.get((Object)"k")).equals("v"));
        Thread.sleep(partial * 2L);
        assert (cache.get((Object)"k") == null);
        while (System.currentTimeMillis() < startTime + 3000L + 2000L && cache.get((Object)"k") != null) {
            Thread.sleep(50L);
        }
        assert (cache.get((Object)"k") == null);
        cache.put((Object)"k", (Object)"v");
        assert (cache.putIfAbsent((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) != null);
    }

    public void testIdleExpiryInPutIfAbsent() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long idleTime = 3000L;
        assert (cache.putIfAbsent((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS) == null);
        assert (((String)cache.get((Object)"k")).equals("v"));
        Thread.sleep(idleTime + 100L);
        assert (cache.get((Object)"k") == null);
        cache.put((Object)"k", (Object)"v");
        assert (cache.putIfAbsent((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS) != null);
    }

    public void testLifespanExpiryInReplace() throws InterruptedException {
        String v;
        Cache cache = this.cm.getCache();
        long lifespan = 3000L;
        assert (cache.get((Object)"k") == null);
        assert (cache.replace((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) == null);
        assert (cache.get((Object)"k") == null);
        cache.put((Object)"k", (Object)"v-old");
        assert (((String)cache.get((Object)"k")).equals("v-old"));
        long startTime = System.currentTimeMillis();
        assert (cache.replace((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS) != null);
        assert (((String)cache.get((Object)"k")).equals("v"));
        while (true) {
            v = (String)cache.get((Object)"k");
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals((String)"v", (String)v);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 2000L && cache.get((Object)"k") != null) {
            Thread.sleep(100L);
        }
        assert (cache.get((Object)"k") == null);
        startTime = System.currentTimeMillis();
        cache.put((Object)"k", (Object)"v");
        assert (cache.replace((Object)"k", (Object)"v", (Object)"v2", 3000L, TimeUnit.MILLISECONDS));
        while (true) {
            v = (String)cache.get((Object)"k");
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals((String)"v2", (String)v);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 2000L && cache.get((Object)"k") != null) {
            Thread.sleep(50L);
        }
        assert (cache.get((Object)"k") == null);
    }

    public void testIdleExpiryInReplace() throws InterruptedException {
        Cache cache = this.cm.getCache();
        long idleTime = 3000L;
        assert (cache.get((Object)"k") == null);
        assert (cache.replace((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS) == null);
        assert (cache.get((Object)"k") == null);
        cache.put((Object)"k", (Object)"v-old");
        assert (((String)cache.get((Object)"k")).equals("v-old"));
        assert (cache.replace((Object)"k", (Object)"v", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS) != null);
        AssertJUnit.assertEquals((String)((String)cache.get((Object)"k")), (String)"v");
        Thread.sleep(idleTime + 100L);
        assert (cache.get((Object)"k") == null);
        cache.put((Object)"k", (Object)"v");
        assert (cache.replace((Object)"k", (Object)"v", (Object)"v2", -1L, TimeUnit.MILLISECONDS, idleTime, TimeUnit.MILLISECONDS));
        Thread.sleep(idleTime + 100L);
        assert (cache.get((Object)"k") == null);
    }

    public void testEntrySetAfterExpiryInPut(Method m) throws Exception {
        this.doTestEntrySetAfterExpiryInPut(m, this.cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doEntrySetAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    private CacheContainer createTransactionalCacheContainer() {
        return TestCacheManagerFactory.createCacheManager(TestCacheManagerFactory.getDefaultConfiguration(true));
    }

    private void doTestEntrySetAfterExpiryInPut(Method m, CacheContainer cc) throws Exception {
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        Set entriesIn = dataIn.entrySet();
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        Set entries = Collections.emptySet();
        while (true) {
            entries = cache.entrySet();
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals(entriesIn, (Object)entries);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
            entries = cache.entrySet();
            if (entries.size() != 0) continue;
            return;
        }
        assert (entries.size() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEntrySetAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Set entries;
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashMap<Integer, String> allEntriesIn = new HashMap<Integer, String>(dataIn);
            allEntriesIn.putAll(txDataIn);
            cache.putAll(txDataIn);
            entries = Collections.emptySet();
            while (true) {
                entries = cache.entrySet();
                if (System.currentTimeMillis() >= startTime + 3000L) break;
                AssertJUnit.assertEquals(allEntriesIn.entrySet(), (Object)entries);
                Thread.sleep(100L);
            }
            while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
                entries = cache.entrySet();
                if (entries.size() != 1) continue;
                return;
            }
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        assert (entries.size() == 1);
    }

    public void testKeySetAfterExpiryInPut(Method m) throws Exception {
        Cache cache = this.cm.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        Set keysIn = dataIn.keySet();
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        Set keys = Collections.emptySet();
        while (true) {
            keys = cache.keySet();
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals(keysIn, (Object)keys);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
            keys = cache.keySet();
            if (keys.size() != 0) continue;
            return;
        }
        assert (keys.size() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKeySetAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doKeySetAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKeySetAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Set keys;
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashMap<Integer, String> allEntriesIn = new HashMap<Integer, String>(dataIn);
            allEntriesIn.putAll(txDataIn);
            cache.putAll(txDataIn);
            keys = Collections.emptySet();
            while (true) {
                keys = cache.keySet();
                if (System.currentTimeMillis() >= startTime + 3000L) break;
                AssertJUnit.assertEquals(allEntriesIn.keySet(), (Object)keys);
                Thread.sleep(100L);
            }
            while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
                keys = cache.keySet();
                if (keys.size() != 1) continue;
                return;
            }
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        assert (keys.size() == 1);
    }

    public void testValuesAfterExpiryInPut(Method m) throws Exception {
        Cache cache = this.cm.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        HashSet valuesIn = new HashSet(dataIn.values());
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        Set values = Collections.emptySet();
        while (true) {
            values = new HashSet(cache.values());
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            AssertJUnit.assertEquals(valuesIn, values);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
            values = new HashSet(cache.values());
            if (values.size() != 0) continue;
            return;
        }
        assert (values.size() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValuesAfterExpiryInTransaction(Method m) throws Exception {
        CacheContainer cc = this.createTransactionalCacheContainer();
        try {
            this.doValuesAfterExpiryInTransaction(m, cc);
        }
        finally {
            cc.stop();
        }
    }

    public void testTransientEntrypUpdates() {
        Cache cache = this.cm.getCache();
        cache.put((Object)1, (Object)"boo", -1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
        cache.put((Object)1, (Object)"boo2");
        cache.put((Object)1, (Object)"boo3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValuesAfterExpiryInTransaction(Method m, CacheContainer cc) throws Exception {
        Set values;
        Cache cache = cc.getCache();
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        cache.getAdvancedCache().getTransactionManager().begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashSet allValuesIn = new HashSet(dataIn.values());
            allValuesIn.addAll(txDataIn.values());
            cache.putAll(txDataIn);
            values = Collections.emptySet();
            while (true) {
                values = new HashSet(cache.values());
                if (System.currentTimeMillis() >= startTime + 3000L) break;
                AssertJUnit.assertEquals(allValuesIn, values);
                Thread.sleep(100L);
            }
            while (System.currentTimeMillis() < startTime + 3000L + 2000L) {
                values = new HashSet(cache.values());
                if (values.size() != 1) continue;
                return;
            }
        }
        finally {
            cache.getAdvancedCache().getTransactionManager().commit();
        }
        assert (values.size() == 1);
    }
}

