/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.TestDelayFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="factories.ComponentRegistryTest")
public class ComponentRegistryTest
extends AbstractInfinispanTest {
    private GlobalComponentRegistry gcr;
    private ComponentRegistry cr1;
    private ComponentRegistry cr2;

    @BeforeMethod
    public void setUp() throws InterruptedException, ExecutionException {
        GlobalConfiguration gc = new GlobalConfigurationBuilder().build();
        Configuration c = new ConfigurationBuilder().build();
        HashSet cachesSet = new HashSet();
        EmbeddedCacheManager cm = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        this.gcr = new GlobalComponentRegistry(gc, cm, cachesSet);
        this.cr1 = new ComponentRegistry("cache", c, cache, this.gcr, ComponentRegistryTest.class.getClassLoader());
        this.cr2 = new ComponentRegistry("cache", c, cache, this.gcr, ComponentRegistryTest.class.getClassLoader());
    }

    public void testSingleThreadLookup() throws InterruptedException, ExecutionException {
        TestDelayFactory.Component c1 = (TestDelayFactory.Component)this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
        Assert.assertNotNull((Object)c1);
        TestDelayFactory.Component c2 = (TestDelayFactory.Component)this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
        Assert.assertNotNull((Object)c2);
    }

    public void testConcurrentLookupSameComponentRegistry() throws InterruptedException, ExecutionException {
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ComponentRegistryTest.this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
            }
        });
        Thread.sleep(500L);
        Assert.assertNull((Object)this.cr1.getComponent(TestDelayFactory.Component.class));
        Assert.assertNotNull((Object)future.get());
        Assert.assertNotNull((Object)this.cr1.getComponent(TestDelayFactory.Component.class));
    }

    public void testConcurrentLookupDifferentComponentRegistries() throws InterruptedException, ExecutionException {
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ComponentRegistryTest.this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
            }
        });
        Thread.sleep(500L);
        Assert.assertNotNull((Object)this.cr2.getOrCreateComponent(TestDelayFactory.Component.class));
        Assert.assertNotNull((Object)future.get());
    }
}

