/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ActivationAndPassivationInterceptorMBeanTest")
public class ActivationAndPassivationInterceptorMBeanTest
extends SingleCacheManagerTest {
    private static final String JMX_DOMAIN = ActivationAndPassivationInterceptorMBeanTest.class.getSimpleName();
    CacheStore cacheStore;
    MBeanServer threadMBeanServer;
    final ObjectName activationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "___defaultcache(local)", "Activation");
    final ObjectName passivationInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "___defaultcache(local)", "Passivation");

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        globalBuilder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup()).jmxDomain(JMX_DOMAIN).enable();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().strategy(EvictionStrategy.LRU).maxEntries(1).jmxStatistics().enable().loaders().passivation(true).addLoader(DummyInMemoryCacheStoreConfigurationBuilder.class);
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder, true);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.cacheStore = this.extractCacheStore();
    }

    @AfterMethod(alwaysRun=true)
    public void resetStats() throws Exception {
        this.threadMBeanServer.invoke(this.activationInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
    }

    public void testDisableStatistics() throws Exception {
        this.threadMBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.FALSE));
        assert (this.threadMBeanServer.getAttribute(this.activationInterceptorObjName, "Activations").toString().equals("N/A"));
        this.threadMBeanServer.setAttribute(this.activationInterceptorObjName, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    public void testActivationOnGet(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testActivationOnPut(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2));
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m, 2)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m))) : "this should only be persisted on evict";
    }

    public void testActivationOnReplace(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        assert (this.cache.replace((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2)).equals(TestingUtil.v(m)));
        this.assertActivationCount(1);
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testActivationOnPutMap(Method m) throws Exception {
        this.assertActivationCount(0);
        assert (this.cache.get((Object)TestingUtil.k(m)) == null);
        this.assertActivationCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m), TestingUtil.v(m)));
        assert (this.cacheStore.containsKey((Object)TestingUtil.k(m)));
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put(TestingUtil.k(m), TestingUtil.v(m, 2));
        this.cache.putAll(toAdd);
        this.assertActivationCount(1);
        assert (this.cache.get((Object)TestingUtil.k(m)).equals(TestingUtil.v(m, 2)));
        assert (!this.cacheStore.containsKey((Object)TestingUtil.k(m)));
    }

    public void testPassivationOnEvict(Method m) throws Exception {
        this.assertPassivationCount(0);
        this.cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        this.cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
        this.cache.evict((Object)TestingUtil.k(m));
        this.assertPassivationCount(1);
        this.cache.evict((Object)TestingUtil.k(m, 2));
        this.assertPassivationCount(2);
        this.cache.evict((Object)"not_existing_key");
        this.assertPassivationCount(2);
    }

    private void assertActivationCount(int activationCount) throws Exception {
        assert (Integer.valueOf(this.threadMBeanServer.getAttribute(this.activationInterceptorObjName, "Activations").toString()).equals(activationCount));
    }

    private void assertPassivationCount(int activationCount) throws Exception {
        Object passivations = this.threadMBeanServer.getAttribute(this.passivationInterceptorObjName, "Passivations");
        AssertJUnit.assertEquals((int)activationCount, (int)Integer.valueOf(passivations.toString()));
    }

    private CacheStore extractCacheStore() {
        return TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
    }
}

