/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheMgmtInterceptorMBeanTest")
public class CacheMgmtInterceptorMBeanTest
extends SingleCacheManagerTest {
    private ObjectName mgmtInterceptor;
    private MBeanServer server;
    AdvancedCache advanced;
    private static final String JMX_DOMAIN = CacheMgmtInterceptorMBeanTest.class.getSimpleName();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        Configuration configuration = CacheMgmtInterceptorMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL);
        configuration.setExposeJmxStatistics(true);
        this.cacheManager.defineConfiguration("test", configuration);
        this.cache = this.cacheManager.getCache("test");
        this.advanced = this.cache.getAdvancedCache();
        this.mgmtInterceptor = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "Statistics");
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return this.cacheManager;
    }

    @AfterMethod(alwaysRun=true)
    public void resetStats() throws Exception {
        this.server.invoke(this.mgmtInterceptor, "resetStatistics", new Object[0], new String[0]);
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.mgmtInterceptor);
    }

    public void testEviction() throws Exception {
        this.assertEvictions(0.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.assertEvictions(0.0f);
        this.cache.evict((Object)"key");
        this.assertEvictions(1.0f);
        this.cache.evict((Object)"does_not_exist");
        this.assertEvictions(2.0f);
    }

    public void testGetKeyValue() throws Exception {
        this.assertMisses(0.0f);
        this.assertHits(0.0f);
        assert (0L == this.advanced.getStats().getHits());
        this.assertAttributeValue("HitRatio", 0.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.assertMisses(0.0f);
        this.assertHits(0.0f);
        this.assertAttributeValue("HitRatio", 0.0f);
        assert (this.cache.get((Object)"key").equals("value"));
        this.assertMisses(0.0f);
        this.assertHits(1.0f);
        this.assertAttributeValue("HitRatio", 1.0f);
        assert (this.cache.get((Object)"key_ne") == null);
        assert (this.cache.get((Object)"key_ne") == null);
        assert (this.cache.get((Object)"key_ne") == null);
        this.assertMisses(3.0f);
        this.assertHits(1.0f);
        this.assertAttributeValue("HitRatio", 0.25f);
    }

    public void testStores() throws Exception {
        this.assertEvictions(0.0f);
        this.assertStores(0.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStores(1.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStores(2.0f);
        this.assertCurrentNumberOfEntries(1.0f);
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put("key", "value");
        toAdd.put("key2", "value2");
        this.cache.putAll(toAdd);
        this.assertStores(4.0f);
        this.assertCurrentNumberOfEntries(2.0f);
        this.resetStats();
        toAdd = new HashMap();
        toAdd.put("key3", "value3");
        toAdd.put("key4", "value4");
        this.cache.putAll(toAdd);
        this.assertStores(2.0f);
        this.assertCurrentNumberOfEntries(4.0f);
    }

    public void testStoresPutForExternalRead() throws Exception {
        this.assertStores(0.0f);
        this.cache.putForExternalRead((Object)"key", (Object)"value");
        this.assertStores(1.0f);
        this.cache.putForExternalRead((Object)"key", (Object)"value");
        this.assertStores(1.0f);
    }

    public void testStoresPutIfAbsent() throws Exception {
        this.assertStores(0.0f);
        this.cache.putIfAbsent((Object)"voooo", (Object)"doooo");
        this.assertStores(1.0f);
        this.cache.putIfAbsent((Object)"voooo", (Object)"no-doooo");
        this.assertStores(1.0f);
    }

    public void testRemoves() throws Exception {
        this.assertStores(0.0f);
        this.assertRemoveHits(0.0f);
        this.assertRemoveMisses(0.0f);
        this.cache.put((Object)"key", (Object)"value");
        this.cache.put((Object)"key2", (Object)"value2");
        this.cache.put((Object)"key3", (Object)"value3");
        this.assertStores(3.0f);
        this.assertRemoveHits(0.0f);
        this.assertRemoveMisses(0.0f);
        this.cache.remove((Object)"key");
        this.cache.remove((Object)"key3");
        this.cache.remove((Object)"key4");
        this.assertRemoveHits(2.0f);
        this.assertRemoveMisses(1.0f);
        this.cache.remove((Object)"key2");
        this.assertRemoveHits(3.0f);
        this.assertRemoveMisses(1.0f);
    }

    private void assertAttributeValue(String attrName, float expectedValue) throws Exception {
        String receivedVal = this.server.getAttribute(this.mgmtInterceptor, attrName).toString();
        assert (Float.parseFloat(receivedVal) == expectedValue) : "expecting " + expectedValue + " for " + attrName + ", but received " + receivedVal;
    }

    private void assertEvictions(float expectedValue) throws Exception {
        this.assertAttributeValue("Evictions", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getEvictions());
    }

    private void assertMisses(float expectedValue) throws Exception {
        this.assertAttributeValue("Misses", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getMisses());
    }

    private void assertHits(float expectedValue) throws Exception {
        this.assertAttributeValue("Hits", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getHits());
    }

    private void assertStores(float expectedValue) throws Exception {
        this.assertAttributeValue("Stores", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getStores());
    }

    private void assertRemoveHits(float expectedValue) throws Exception {
        this.assertAttributeValue("RemoveHits", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getRemoveHits());
    }

    private void assertRemoveMisses(float expectedValue) throws Exception {
        this.assertAttributeValue("RemoveMisses", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getRemoveMisses());
    }

    private void assertCurrentNumberOfEntries(float expectedValue) throws Exception {
        this.assertAttributeValue("NumberOfEntries", expectedValue);
        assert (expectedValue == (float)this.advanced.getStats().getCurrentNumberOfEntries());
    }
}

