/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.JmxStatsFunctionalTest")
public class JmxStatsFunctionalTest
extends AbstractInfinispanTest {
    public static final String JMX_DOMAIN = JmxStatsFunctionalTest.class.getSimpleName();
    private MBeanServer server;
    private EmbeddedCacheManager cm;
    private EmbeddedCacheManager cm2;
    private EmbeddedCacheManager cm3;

    @AfterMethod(alwaysRun=true)
    public void destroyCacheManager() {
        TestingUtil.killCacheManagers(this.cm, this.cm2, this.cm3);
        this.cm = null;
        this.cm2 = null;
        this.cm3 = null;
        this.server = null;
    }

    public void testDefaultDomain() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        String jmxDomain = this.cm.getGlobalConfiguration().getJmxDomain();
        Configuration localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache);
        Configuration remote1 = this.config();
        remote1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1);
        Configuration remote2 = this.config();
        remote2.setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        this.cm.defineConfiguration("remote2", remote2);
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        this.cm.getCache("remote2");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "RpcManager")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "Statistics")));
        TestingUtil.killCacheManagers(this.cm);
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "RpcManager")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "Statistics")));
    }

    public void testDifferentDomain() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        String jmxDomain = this.cm.getGlobalConfiguration().getJmxDomain();
        Configuration localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
    }

    public void testOnlyGlobalJmxStatsEnabled() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        String jmxDomain = globalConfiguration.getJmxDomain();
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(false);
        this.cm.defineConfiguration("local_cache", localCache);
        Configuration remote1 = this.config();
        remote1.setExposeJmxStatistics(false);
        remote1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1);
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        assert (TestingUtil.existsObject(TestingUtil.getCacheManagerObjectName(jmxDomain)));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "LockManager")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "LockManager")));
    }

    public void testOnlyPerCacheJmxStatsEnabled() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(false);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        String jmxDomain = globalConfiguration.getJmxDomain();
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(true);
        this.cm.defineConfiguration("local_cache", localCache);
        Configuration remote1 = this.config();
        remote1.setExposeJmxStatistics(true);
        remote1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1);
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheManagerObjectName(jmxDomain)));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleManagersOnSameServerFails(Method method) throws Exception {
        String jmxDomain = JMX_DOMAIN + '.' + method.getName();
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setJmxDomain(jmxDomain);
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(true);
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        GlobalConfiguration globalConfiguration2 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration2.setJmxDomain(jmxDomain);
        globalConfiguration2.setExposeGlobalJmxStatistics(true);
        globalConfiguration2.setAllowDuplicateDomains(false);
        globalConfiguration2.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        try {
            TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration2);
            assert (false) : "Failure expected, '" + jmxDomain + "' duplicate!";
        }
        catch (JmxDomainConflictException e) {
            // empty catch block
        }
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        globalConfiguration2.setAllowDuplicateDomains(true);
        EmbeddedCacheManager duplicateAllowedContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration2);
        try {
            String duplicateName = jmxDomain + "2";
            ObjectName duplicateObjectName = TestingUtil.getCacheManagerObjectName(duplicateName);
            this.server.getAttribute(duplicateObjectName, "CreatedCacheCount").equals("0");
        }
        finally {
            duplicateAllowedContainer.stop();
        }
    }

    public void testMultipleManagersOnSameServerWithCloneFails() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(true);
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        String jmxDomain = globalConfiguration.getJmxDomain();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        GlobalConfiguration globalConfigurationClone = globalConfiguration.clone();
        globalConfigurationClone.setExposeGlobalJmxStatistics(true);
        globalConfigurationClone.setAllowDuplicateDomains(false);
        globalConfigurationClone.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        try {
            TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfigurationClone);
            assert (false) : "Failure expected!";
        }
        catch (JmxDomainConflictException e) {
            // empty catch block
        }
    }

    public void testMultipleManagersOnSameServer() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setAllowDuplicateDomains(true);
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        String jmxDomain = globalConfiguration.getJmxDomain();
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(true);
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        GlobalConfiguration globalConfiguration2 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration2.setExposeGlobalJmxStatistics(true);
        globalConfiguration2.setAllowDuplicateDomains(true);
        globalConfiguration2.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm2 = TestCacheManagerFactory.createCacheManager(globalConfiguration2);
        String jmxDomain2 = this.cm2.getGlobalConfiguration().getJmxDomain();
        Configuration localCache2 = this.config();
        localCache2.setExposeJmxStatistics(true);
        this.cm2.defineConfiguration("local_cache", localCache);
        this.cm2.getCache("local_cache");
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "local_cache(local)", "Statistics")));
        GlobalConfiguration globalConfiguration3 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration3.setExposeGlobalJmxStatistics(true);
        globalConfiguration3.setAllowDuplicateDomains(true);
        globalConfiguration3.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm3 = TestCacheManagerFactory.createCacheManager(globalConfiguration3);
        Configuration localCache3 = this.config();
        localCache3.setExposeJmxStatistics(true);
        this.cm3.defineConfiguration("local_cache", localCache);
        this.cm3.getCache("local_cache");
        String jmxDomain3 = this.cm3.getGlobalConfiguration().getJmxDomain();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain3, "local_cache(local)", "Statistics")));
    }

    public void testUnregisterJmxInfoOnStop() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        Configuration localCache = this.config();
        localCache.setExposeJmxStatistics(true);
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        String jmxDomain = globalConfiguration.getJmxDomain();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        TestingUtil.killCacheManagers(this.cm);
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (!TestingUtil.existsDomains(jmxDomain));
    }

    public void testCorrectUnregistering() throws Exception {
        assert (!TestingUtil.existsDomains("infinispan"));
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        Configuration localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache);
        this.cm.getCache("local_cache");
        String jmxDomain = this.cm.getGlobalConfiguration().getJmxDomain();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Cache")));
        GlobalConfiguration globalConfiguration2 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration2.setExposeGlobalJmxStatistics(true);
        globalConfiguration2.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration2.setAllowDuplicateDomains(true);
        this.cm2 = TestCacheManagerFactory.createCacheManager(globalConfiguration2);
        Configuration remoteCache = new Configuration();
        remoteCache.setExposeJmxStatistics(true);
        remoteCache.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cm2.defineConfiguration("remote_cache", remoteCache);
        this.cm2.getCache("remote_cache");
        String jmxDomain2 = this.cm2.getGlobalConfiguration().getJmxDomain();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Cache")));
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
        this.cm2.stop();
        assert (TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "CacheComponent")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
        this.cm.stop();
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        assert (!TestingUtil.existsObject(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
    }

    public void testStopUnstartedCacheManager() {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        this.cm = TestCacheManagerFactory.createCacheManager(false, globalConfiguration);
        this.cm.stop();
    }

    private Configuration config() {
        Configuration configuration = new Configuration();
        configuration.setFetchInMemoryState(false);
        configuration.setExposeJmxStatistics(true);
        return configuration;
    }
}

