/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.RpcManagerMBeanTest")
public class RpcManagerMBeanTest
extends MultipleCacheManagersTest {
    private final String cachename = "repl_sync_cache";
    public static final String JMX_DOMAIN = RpcManagerMBeanTest.class.getSimpleName();
    public static final String JMX_DOMAIN2 = JMX_DOMAIN + "2";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfig = new ConfigurationBuilder();
        GlobalConfigurationBuilder gcb1 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb1.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true)).jmxDomain(JMX_DOMAIN).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(gcb1, defaultConfig, new TransportFlags(), true);
        cacheManager1.start();
        GlobalConfigurationBuilder gcb2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb2.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true)).jmxDomain(JMX_DOMAIN).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(gcb2, defaultConfig, new TransportFlags(), true);
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.REPL_SYNC).jmxStatistics().enable();
        this.defineConfigurationOnAllManagers("repl_sync_cache", cb);
        this.waitForClusterToForm("repl_sync_cache");
    }

    public void testJmxOperationMetadata() throws Exception {
        ObjectName rpcManager = TestingUtil.getCacheObjectName(JMX_DOMAIN, "repl_sync_cache(repl_sync)", "RpcManager");
        TestingUtil.checkMBeanOperationParameterNaming(rpcManager);
    }

    public void testEnableJmxStats() throws Exception {
        Cache cache1 = this.manager(0).getCache("repl_sync_cache");
        Cache cache2 = this.manager(1).getCache("repl_sync_cache");
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(JMX_DOMAIN, "repl_sync_cache(repl_sync)", "RpcManager");
        ObjectName rpcManager2 = TestingUtil.getCacheObjectName(JMX_DOMAIN2, "repl_sync_cache(repl_sync)", "RpcManager");
        assert (mBeanServer.isRegistered(rpcManager1));
        assert (mBeanServer.isRegistered(rpcManager2));
        Object statsEnabled = mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled");
        assert (statsEnabled != null);
        Assert.assertEquals((Object)statsEnabled, (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager2, "StatisticsEnabled"), (Object)Boolean.TRUE);
        long initialReplicationCount1 = (Long)mBeanServer.getAttribute(rpcManager1, "ReplicationCount");
        cache1.put((Object)"key", (Object)"value2");
        Assert.assertEquals((Object)cache2.get((Object)"key"), (Object)"value2");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)(initialReplicationCount1 + 1L));
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.invoke(rpcManager1, "resetStatistics", new Object[0], new String[0]);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.FALSE));
        cache1.put((Object)"key", (Object)"value");
        Assert.assertEquals((Object)cache2.get((Object)"key"), (Object)"value");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)-1L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)-1L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testEnableJmxStats"})
    public void testSuccessRatio() throws Exception {
        Cache cache1 = this.manager(0).getCache("repl_sync_cache");
        Cache cache2 = this.manager(1).getCache("repl_sync_cache");
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(JMX_DOMAIN, "repl_sync_cache(repl_sync)", "RpcManager");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"N/A");
        cache1.put((Object)"a1", (Object)new SlowToSerialize("b1", 50L));
        cache1.put((Object)"a2", (Object)new SlowToSerialize("b2", 50L));
        cache1.put((Object)"a3", (Object)new SlowToSerialize("b3", 50L));
        cache1.put((Object)"a4", (Object)new SlowToSerialize("b4", 50L));
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)4L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"100%");
        Object avgReplTime = mBeanServer.getAttribute(rpcManager1, "AverageReplicationTime");
        Assert.assertNotEquals((Object)avgReplTime, (Object)0L);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = rpcManager.getTransport();
        try {
            Address mockAddress1 = (Address)Mockito.mock(Address.class);
            Address mockAddress2 = (Address)Mockito.mock(Address.class);
            ArrayList<Address> memberList = new ArrayList<Address>(2);
            memberList.add(mockAddress1);
            memberList.add(mockAddress2);
            Transport transport = (Transport)Mockito.mock(Transport.class);
            Mockito.when((Object)transport.getMembers()).thenReturn(memberList);
            Mockito.when((Object)transport.getAddress()).thenReturn(null);
            Mockito.when((Object)transport.invokeRemotely((Collection)Matchers.any(Collection.class), (ReplicableCommand)Matchers.any(ReplicableCommand.class), (ResponseMode)Matchers.any(ResponseMode.class), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.any(ResponseFilter.class))).thenThrow(new Throwable[]{new RuntimeException()});
            rpcManager.setTransport(transport);
            cache1.put((Object)"a5", (Object)"b5");
            assert (false) : "rpc manager should have thrown an exception";
        }
        catch (Throwable expected) {
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"80%");
        }
        finally {
            rpcManager.setTransport(originalTransport);
        }
    }

    public static class SlowToSerialize
    implements Externalizable {
        String val;
        transient long delay;

        public SlowToSerialize() {
        }

        private SlowToSerialize(String val, long delay) {
            this.val = val;
            this.delay = delay;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.val);
            TestingUtil.sleepThread(this.delay);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.val = (String)in.readObject();
            TestingUtil.sleepThread(this.delay);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SlowToSerialize that = (SlowToSerialize)o;
            return !(this.val != null ? !this.val.equals(that.val) : that.val != null);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }
    }
}

