/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.ClassLoaderManagerDisablingTest")
public class ClassLoaderManagerDisablingTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        try {
            this.checkAndDisableStore(cm);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryCacheStoreConfigurationBuilder)builder.loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).async().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        try {
            this.checkAndDisableStore(cm);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingletonStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryCacheStoreConfigurationBuilder)builder.loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).singletonStore().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        try {
            this.checkAndDisableStore(cm);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChainingStoreDisabling() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryCacheStoreConfigurationBuilder)((DummyInMemoryCacheStoreConfigurationBuilder)builder.loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).async().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        try {
            this.checkAndDisableStore(cm, 2);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    private void checkAndDisableStore(EmbeddedCacheManager cm) {
        this.checkAndDisableStore(cm, 1);
    }

    private void checkAndDisableStore(EmbeddedCacheManager cm, int count) {
        Cache cache = cm.getCache();
        CacheLoaderManager clm = TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        AssertJUnit.assertTrue((boolean)clm.isEnabled());
        AssertJUnit.assertEquals((int)count, (int)clm.getCacheLoaders(DummyInMemoryCacheStore.class).size());
        clm.disableCacheStore(DummyInMemoryCacheStore.class.getName());
        AssertJUnit.assertFalse((boolean)clm.isEnabled());
    }
}

