/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.ClusterCacheLoaderTest")
public class ClusterCacheLoaderTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager();
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        ConfigurationBuilder config1 = ClusterCacheLoaderTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false);
        config1.loaders().addClusterCacheLoader();
        ConfigurationBuilder config2 = ClusterCacheLoaderTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false);
        config2.loaders().addClusterCacheLoader();
        config2.loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore());
        cacheManager1.defineConfiguration("clusteredCl", config1.build());
        cacheManager2.defineConfiguration("clusteredCl", config2.build());
        this.waitForClusterToForm("clusteredCl");
    }

    public void testRemoteLoad() {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        assert (cache1.get((Object)"key") == null);
        assert (cache1.get((Object)"key") == null);
        cache2.put((Object)"key", (Object)"value");
        assert ("value".equals(cache1.get((Object)"key")));
    }

    public void testRemoteLoadFromCacheLoader() throws Exception {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        CacheLoaderManager manager2 = (CacheLoaderManager)cache2.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        ChainingCacheStore chainingCacheStore = (ChainingCacheStore)manager2.getCacheStore();
        CacheStore cs2 = (CacheStore)chainingCacheStore.getStores().keySet().iterator().next();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        cs2.store(TestInternalCacheEntryFactory.create("key", "value"));
        assert (cs2.load((Object)"key").getValue().equals("value"));
        assert (((String)cache1.get((Object)"key")).equals("value"));
    }
}

