/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.FlushingAsyncStoreTest", sequential=true)
public class FlushingAsyncStoreTest
extends SingleCacheManagerTest {
    private boolean storeWasRun = false;

    public FlushingAsyncStoreTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration config = this.getDefaultStandaloneConfig(false).fluent().loaders().addCacheLoader(new CacheLoaderConfig[]{new SlowCacheStoreConfig().storeName(this.getClass().getName()).asyncStore().threadPoolSize(Integer.valueOf(1)).build()}).build();
        return TestCacheManagerFactory.createCacheManager(config);
    }

    @Test(timeOut=10000L)
    public void writeOnStorage() {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.cache = this.cacheManager.getCache("AsyncStoreInMemory");
        this.cache.put((Object)"key1", (Object)"value");
        this.cache.stop();
        this.storeWasRun = true;
    }

    @Test(dependsOnMethods={"writeOnStorage"})
    public void verifyStorageContent() {
        assert (this.storeWasRun);
        this.cache = this.cacheManager.getCache("AsyncStoreInMemory");
        assert ("value".equals(this.cache.get((Object)"key1")));
    }

    @CacheLoaderMetadata(configurationClass=SlowCacheStoreConfig.class)
    public static class SlowCacheStore
    extends DummyInMemoryCacheStore {
        private void insertDelay() {
            TestingUtil.sleepThread(100L);
        }

        @Override
        public void store(InternalCacheEntry ed) {
            this.insertDelay();
            super.store(ed);
        }
    }

    public static class SlowCacheStoreConfig
    extends DummyInMemoryCacheStore.Cfg {
        public SlowCacheStoreConfig() {
            this.setCacheLoaderClassName(SlowCacheStore.class.getName());
        }
    }
}

