/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="loaders.PassivatePersistentTest", groups={"functional"})
public class PassivatePersistentTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    CacheStore store;
    TransactionManager tm;
    Configuration cfg;
    CacheContainer cm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cfg = new Configuration().fluent().loaders().passivation(Boolean.valueOf(true)).addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().storeName(this.getClass().getName()).purgeOnStartup(false)}).build();
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.store.clear();
        TestingUtil.killCacheManagers(this.cm);
    }

    public void testPersistence() throws CacheLoaderException {
        this.cache.put((Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get((Object)"k")));
        this.cache.evict((Object)"k");
        assert (this.store.containsKey((Object)"k"));
        assert ("v".equals(this.cache.get((Object)"k")));
        assert (!this.store.containsKey((Object)"k"));
        this.cache.stop();
        this.cache.start();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        assert (this.store.containsKey((Object)"k"));
        assert ("v".equals(this.cache.get((Object)"k")));
        assert (!this.store.containsKey((Object)"k"));
    }
}

