/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(testName="loaders.SharedCacheStoreTest", groups={"functional"})
@CleanupAfterMethod
public class SharedCacheStoreTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = new Configuration().fluent().loaders().shared(Boolean.valueOf(true)).addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().storeName(SharedCacheStoreTest.class.getName()).purgeOnStartup(false)}).clustering().mode(Configuration.CacheMode.REPL_SYNC).build();
        this.createCluster(cfg, 3);
    }

    public void testUnnecessaryWrites() throws CacheLoaderException {
        DummyInMemoryCacheStore dimcs;
        this.cache(0).put((Object)"key", (Object)"value");
        for (Cache c : this.caches()) {
            assert ("value".equals(c.get((Object)"key")));
        }
        List<CacheStore> cachestores = TestingUtil.cachestores(this.caches());
        for (CacheStore cacheStore : cachestores) {
            assert (cacheStore.containsKey((Object)"key"));
            dimcs = (DummyInMemoryCacheStore)cacheStore;
            assert (dimcs.stats().get("clear") == 0) : "Cache store should not be cleared, purgeOnStartup is false";
            assert (dimcs.stats().get("store") == 1) : "Cache store should have been written to just once, but was written to " + dimcs.stats().get("store") + " times";
        }
        this.cache(0).remove((Object)"key");
        for (Cache cache : this.caches()) {
            assert (cache.get((Object)"key") == null);
        }
        for (CacheStore cacheStore : cachestores) {
            assert (!cacheStore.containsKey((Object)"key"));
            dimcs = (DummyInMemoryCacheStore)cacheStore;
            assert (dimcs.stats().get("remove") == 1) : "Entry should have been removed from the cache store just once, but was removed " + dimcs.stats().get("store") + " times";
        }
    }

    public void testSkipSharedCacheStoreFlagUsage() throws CacheLoaderException {
        this.cache(0).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_SHARED_CACHE_STORE}).put((Object)"key", (Object)"value");
        assert (this.cache(0).get((Object)"key").equals("value"));
        List<CacheStore> cachestores = TestingUtil.cachestores(this.caches());
        for (CacheStore cs : cachestores) {
            assert (!cs.containsKey((Object)"key"));
            DummyInMemoryCacheStore dimcs = (DummyInMemoryCacheStore)cs;
            assert (dimcs.stats().get("store") == 0) : "Cache store should NOT contain any entry. Put was with SKIP_SHARED_CACHE_STORE flag.";
        }
    }
}

