/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.decorators.AsyncStoreEvictionTest")
public class AsyncStoreEvictionTest {
    private static final boolean USE_ASYNC_STORE = true;
    private static final ThreadLocal<LockableCacheStore> STORE = new ThreadLocal();

    private static ConfigurationBuilder config(boolean passivation, int threads) {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.expiration().wakeUpInterval(100L);
        config.eviction().maxEntries(1).strategy(EvictionStrategy.LRU);
        LegacyStoreConfigurationBuilder store = config.loaders().passivation(passivation).addStore().cacheStore((CacheStore)new LockableCacheStore());
        store.async().enable().threadPoolSize(threads);
        return config;
    }

    public void testEndToEndEvictionPassivation() throws Exception {
        this.testEndToEndEviction(true);
    }

    public void testEndToEndEviction() throws Exception {
        this.testEndToEndEviction(false);
    }

    private void testEndToEndEviction(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 1)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                this.store.lock.lock();
                try {
                    this.cache.put((Object)"k1", (Object)"v1");
                    this.cache.put((Object)"k2", (Object)"v2");
                    TestingUtil.sleepThread(100L);
                    this.cache.put((Object)"k3", (Object)"v3");
                    this.cache.put((Object)"k4", (Object)"v4");
                    assert ("v3".equals(this.cache.get((Object)"k3"))) : "cache must return k3 == v3 (was: " + (String)this.cache.get((Object)"k3") + ")";
                }
                finally {
                    this.store.lock.unlock();
                }
            }
        });
    }

    public void testEndToEndUpdatePassivation() throws Exception {
        this.testEndToEndUpdate(true);
    }

    public void testEndToEndUpdate() throws Exception {
        this.testEndToEndUpdate(false);
    }

    private void testEndToEndUpdate(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 1)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v0");
                this.cache.put((Object)"k2", (Object)"v2");
                while (this.store.load("k1") == null) {
                    TestingUtil.sleepThread(10L);
                }
                this.store.lock.lock();
                try {
                    this.cache.put((Object)"k3", (Object)"v3");
                    this.cache.put((Object)"k4", (Object)"v4");
                    TestingUtil.sleepThread(100L);
                    this.cache.put((Object)"k1", (Object)"v1");
                    this.cache.put((Object)"k5", (Object)"v5");
                    assert ("v1".equals(this.cache.get((Object)"k1"))) : "cache must return k1 == v1 (was: " + (String)this.cache.get((Object)"k1") + ")";
                }
                finally {
                    this.store.lock.unlock();
                }
            }
        });
    }

    public void testEndToEndRemovePassivation() throws Exception {
        this.testEndToEndRemove(true);
    }

    public void testEndToEndRemove() throws Exception {
        this.testEndToEndRemove(false);
    }

    private void testEndToEndRemove(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(passivation, 2)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                while (this.store.load("k1") == null) {
                    TestingUtil.sleepThread(10L);
                }
                this.store.lock.lock();
                try {
                    this.cache.remove((Object)"k1");
                    TestingUtil.sleepThread(100L);
                    this.cache.remove((Object)"k1");
                    TestingUtil.sleepThread(200L);
                    assert (null == this.cache.get((Object)"k1")) : "cache must return k1 == null (was: " + (String)this.cache.get((Object)"k1") + ")";
                }
                finally {
                    this.store.lock.unlock();
                }
            }
        });
    }

    public void testNPE() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.remove((Object)"k1");
                this.cache.put((Object)"k2", (Object)"v2");
            }
        });
    }

    public void testLIRS() throws Exception {
        ConfigurationBuilder config = AsyncStoreEvictionTest.config(false, 1);
        config.eviction().strategy(EvictionStrategy.LIRS).maxEntries(1);
        TestingUtil.withCacheManager(new CacheCallable(config){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                this.cache.put((Object)"k1", (Object)"v3");
                this.cache.put((Object)"k2", (Object)"v4");
                this.cache.put((Object)"k3", (Object)"v3");
                this.cache.put((Object)"k4", (Object)"v4");
            }
        });
    }

    public void testSize() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                assert (this.cache.size() == 1) : "cache size must be 1, was: " + this.cache.size();
            }
        });
    }

    public void testSizeAfterExpiration() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.put((Object)"k2", (Object)"v2");
                TestingUtil.sleepThread(200L);
                assert (this.cache.size() != 2) : "expiry doesn't work even after expiration";
            }
        });
    }

    public void testSizeAfterEvict() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.evict((Object)"k1");
                assert (this.cache.size() == 0) : "cache size must be 0, was: " + this.cache.size();
            }
        });
    }

    public void testSizeAfterRemove() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.remove((Object)"k1");
                assert (this.cache.size() == 0) : "cache size must be 0, was: " + this.cache.size();
            }
        });
    }

    public void testSizeAfterRemoveAndExpiration() throws Exception {
        TestingUtil.withCacheManager(new CacheCallable(AsyncStoreEvictionTest.config(false, 1)){

            @Override
            public void call() {
                this.cache.put((Object)"k1", (Object)"v1");
                this.cache.remove((Object)"k1");
                int size = this.cache.size();
                TestingUtil.sleepThread(200L);
                assert (size != 1 || this.cache.size() != 0) : "remove only works after expiration";
            }
        });
    }

    private static abstract class CacheCallable
    extends CacheManagerCallable {
        protected final Cache<String, String> cache;
        protected final LockableCacheStore store;

        CacheCallable(ConfigurationBuilder builder) {
            super(TestCacheManagerFactory.createCacheManager(builder));
            this.cache = this.cm.getCache();
            this.store = (LockableCacheStore)((Object)STORE.get());
        }
    }

    @CacheLoaderMetadata(configurationClass=LockableCacheStoreConfig.class)
    public static class LockableCacheStore
    extends DummyInMemoryCacheStore {
        private final ReentrantLock lock = new ReentrantLock();

        public LockableCacheStore() {
            STORE.set(this);
        }

        @Override
        public Class<? extends CacheLoaderConfig> getConfigurationClass() {
            return LockableCacheStoreConfig.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(InternalCacheEntry ed) {
            this.lock.lock();
            try {
                super.store(ed);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key) {
            this.lock.lock();
            try {
                boolean bl = super.remove(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class LockableCacheStoreConfig
    extends DummyInMemoryCacheStore.Cfg {
        private static final long serialVersionUID = 1L;

        public LockableCacheStoreConfig() {
            this.setCacheLoaderClassName(LockableCacheStore.class.getName());
        }
    }
}

