/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheLoaderManagerImpl;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.AsyncStoreFunctionalTest")
public class AsyncStoreFunctionalTest {
    private static final Log log = LogFactory.getLog(AsyncStoreFunctionalTest.class);

    public void testPutAfterPassivation() {
        ConfigurationBuilder builder = this.asyncStoreWithEvictionBuilder();
        builder.loaders().passivation(true);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cm);
                gcr.getComponentMetadataRepo().injectFactoryForComponent(CacheLoaderManager.class, CustomCacheLoaderManagerFactory.class);
                Cache cache = this.cm.getCache();
                MockAsyncStore cacheStore = AsyncStoreFunctionalTest.this.getMockAsyncStore((Cache<Integer, String>)cache);
                CountDownLatch modApplyLatch = cacheStore.modApplyLatch;
                CountDownLatch lockedWaitLatch = cacheStore.lockedWaitLatch;
                cache.put((Object)1, (Object)"v1");
                cache.put((Object)2, (Object)"v2");
                try {
                    log.trace((Object)"Wait for async store to lock keys");
                    lockedWaitLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                }
                finally {
                    modApplyLatch.countDown();
                }
            }
        });
    }

    public void testPutAfterEviction() {
        ConfigurationBuilder builder = this.asyncStoreWithEvictionBuilder();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cm);
                gcr.getComponentMetadataRepo().injectFactoryForComponent(CacheLoaderManager.class, CustomCacheLoaderManagerFactory.class);
                Cache cache = this.cm.getCache();
                MockAsyncStore cacheStore = AsyncStoreFunctionalTest.this.getMockAsyncStore((Cache<Integer, String>)cache);
                CountDownLatch modApplyLatch = cacheStore.modApplyLatch;
                CountDownLatch lockedWaitLatch = cacheStore.lockedWaitLatch;
                cache.put((Object)1, (Object)"v1");
                try {
                    log.trace((Object)"Wait for async store to lock keys");
                    lockedWaitLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                cache.put((Object)2, (Object)"v2");
                try {
                    AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                    AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)2)));
                }
                finally {
                    modApplyLatch.countDown();
                }
            }
        });
    }

    public void testGetAfterRemove() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryCacheStoreConfigurationBuilder)builder.loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).async().enabled(true);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cm);
                gcr.getComponentMetadataRepo().injectFactoryForComponent(CacheLoaderManager.class, CustomCacheLoaderManagerFactory.class);
                Cache cache = this.cm.getCache();
                MockAsyncStore cacheStore = AsyncStoreFunctionalTest.this.getMockAsyncStore((Cache<Integer, String>)cache);
                CountDownLatch modApplyLatch = cacheStore.modApplyLatch;
                CountDownLatch lockedWaitLatch = cacheStore.lockedWaitLatch;
                cache.put((Object)1, (Object)"skip");
                ((DummyInMemoryCacheStore)cacheStore.getDelegate()).blockUntilCacheStoreContains(1, "skip", 60000L);
                cache.remove((Object)1);
                try {
                    lockedWaitLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    AssertJUnit.assertEquals(null, (String)((String)cache.get((Object)1)));
                }
                finally {
                    modApplyLatch.countDown();
                }
                DataContainer dataContainer = TestingUtil.extractComponent(cache, DataContainer.class);
                dataContainer.purgeExpired();
                Set keys = cache.keySet();
                AssertJUnit.assertTrue((String)("Keys not empty: " + keys), (boolean)keys.isEmpty());
                Set entries = cache.entrySet();
                AssertJUnit.assertTrue((String)("Entry set not empty: " + entries), (boolean)entries.isEmpty());
                Collection values = cache.values();
                AssertJUnit.assertTrue((String)("Values not empty: " + values), (boolean)values.isEmpty());
            }
        });
    }

    private MockAsyncStore getMockAsyncStore(Cache<Integer, String> cache) {
        CustomCacheLoaderManager cacheLoaderManager = (CustomCacheLoaderManager)TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        return (MockAsyncStore)cacheLoaderManager.getCacheStore();
    }

    private ConfigurationBuilder asyncStoreWithEvictionBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryCacheStoreConfigurationBuilder)builder.eviction().strategy(EvictionStrategy.LRU).maxEntries(1).loaders().addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).async().enabled(true);
        return builder;
    }

    public static class CustomCacheLoaderManager
    extends CacheLoaderManagerImpl {
        protected AsyncStore createAsyncStore(CacheStore tmpStore, CacheStoreConfig cfg2) {
            CountDownLatch modApplyLatch = new CountDownLatch(1);
            CountDownLatch lockedWaitLatch = new CountDownLatch(1);
            return new MockAsyncStore(modApplyLatch, lockedWaitLatch, tmpStore, cfg2.getAsyncStoreConfig());
        }
    }

    public static class CustomCacheLoaderManagerFactory
    extends AbstractNamedCacheComponentFactory
    implements AutoInstantiableFactory {
        public <T> T construct(Class<T> componentType) {
            return (T)((Object)new CustomCacheLoaderManager());
        }
    }

    public static class MockAsyncStore
    extends AsyncStore {
        private static final Log log = LogFactory.getLog(MockAsyncStore.class);
        private final CountDownLatch modApplyLatch;
        private final CountDownLatch lockedWaitLatch;

        public MockAsyncStore(CountDownLatch modApplyLatch, CountDownLatch lockedWaitLatch, CacheStore delegate, AsyncStoreConfig asyncStoreConfig) {
            super(delegate, asyncStoreConfig);
            this.modApplyLatch = modApplyLatch;
            this.lockedWaitLatch = lockedWaitLatch;
        }

        protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
            try {
                if (this.containsModificationForKey(1, mods) && !this.isSkip(this.findModificationForKey(1, mods))) {
                    log.tracef("Wait to apply modifications: %s", mods);
                    this.lockedWaitLatch.countDown();
                    this.modApplyLatch.await(60L, TimeUnit.SECONDS);
                    log.tracef("Apply modifications: %s", mods);
                }
                super.applyModificationsSync(mods);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private boolean containsModificationForKey(Object key, List<Modification> mods) {
            return this.findModificationForKey(key, mods) != null;
        }

        private Modification findModificationForKey(Object key, List<Modification> mods) {
            block4: for (Modification modification : mods) {
                switch (modification.getType()) {
                    case STORE: {
                        Store store = (Store)modification;
                        if (!store.getStoredEntry().getKey().equals(key)) continue block4;
                        return store;
                    }
                    case REMOVE: {
                        Remove remove = (Remove)modification;
                        if (!remove.getKey().equals(key)) continue block4;
                        return remove;
                    }
                }
                return null;
            }
            return null;
        }

        private boolean isSkip(Modification mod) {
            if (mod instanceof Store) {
                InternalCacheEntry storedEntry = ((Store)mod).getStoredEntry();
                return storedEntry.getValue().equals("skip");
            }
            return false;
        }
    }
}

