/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.decorators.ChainingCacheLoaderTest")
public class ChainingCacheLoaderTest
extends BaseCacheStoreTest {
    DummyInMemoryCacheStore store1;
    DummyInMemoryCacheStore store2;
    DummyInMemoryCacheStore[] stores;
    private static final long lifespan = 6000000L;

    @Override
    protected CacheStore createCacheStore() throws CacheLoaderException {
        ChainingCacheStore store = new ChainingCacheStore();
        DummyInMemoryCacheStore.Cfg cfg = new DummyInMemoryCacheStore.Cfg().storeName("ChainingCacheLoaderTest_instance1").purgeOnStartup(false).fetchPersistentState(false);
        this.store1 = new DummyInMemoryCacheStore();
        this.store1.init((CacheLoaderConfig)cfg, null, new TestObjectStreamMarshaller());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        LegacyConfigurationAdaptor.adapt((ClassLoader)Thread.currentThread().getContextClassLoader(), (ConfigurationBuilder)builder, (CacheLoaderConfig)cfg);
        store.addCacheLoader((CacheLoader)this.store1, (CacheLoaderConfiguration)builder.build().loaders().cacheLoaders().get(0));
        this.store2 = new DummyInMemoryCacheStore();
        cfg = new DummyInMemoryCacheStore.Cfg().storeName("ChainingCacheLoaderTest_instance2").purgeOnStartup(false).fetchPersistentState(true);
        this.store2.init((CacheLoaderConfig)cfg, null, new TestObjectStreamMarshaller());
        builder = new ConfigurationBuilder();
        LegacyConfigurationAdaptor.adapt((ClassLoader)Thread.currentThread().getContextClassLoader(), (ConfigurationBuilder)builder, (CacheLoaderConfig)cfg);
        store.addCacheLoader((CacheLoader)this.store2, (CacheLoaderConfiguration)builder.build().loaders().cacheLoaders().get(0));
        this.stores = new DummyInMemoryCacheStore[]{this.store1, this.store2};
        store.start();
        return store;
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        if (this.store1 != null) {
            this.store1.clear();
        }
        if (this.store2 != null) {
            this.store2.clear();
        }
    }

    public void testPropagatingWrites() throws Exception {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2", 6000000L));
        int i = 1;
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (s.containsKey("k1")) : "Key k1 missing on store " + i;
            assert (s.containsKey("k2")) : "Key k2 missing on store " + i;
            assert (s.load("k1").getValue().equals("v1"));
            assert (s.load("k2").getValue().equals("v2"));
            assert (s.load("k1").getLifespan() == -1L);
            assert (s.load("k2").getLifespan() == 6000000L);
            ++i;
        }
        this.cs.remove((Object)"k1");
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (!s.containsKey("k1"));
            assert (s.containsKey("k2"));
            assert (s.load("k1") == null);
            assert (s.load("k2").getValue().equals("v2"));
            assert (s.load("k2").getLifespan() == 6000000L);
        }
        this.cs.clear();
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (!s.containsKey("k1"));
            assert (!s.containsKey("k2"));
            assert (s.load("k1") == null);
            assert (s.load("k2") == null);
        }
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2", 6000000L));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3", 1000L));
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (s.containsKey("k1"));
            assert (s.containsKey("k2"));
            assert (s.containsKey("k3"));
        }
        Thread.sleep(1100L);
        this.cs.purgeExpired();
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (s.containsKey("k1"));
            assert (s.containsKey("k2"));
            assert (!s.containsKey("k3"));
        }
    }

    public void testGetsFromMultipleSrcs() throws Exception {
        assert (this.cs.load((Object)"k1") == null);
        assert (this.cs.load((Object)"k2") == null);
        assert (this.cs.load((Object)"k3") == null);
        assert (this.cs.load((Object)"k4") == null);
        this.store1.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        Assert.assertEquals((int)this.cs.loadAll().size(), (int)1);
        this.store2.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        Assert.assertEquals((int)this.cs.loadAll().size(), (int)2);
        this.store1.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        Assert.assertEquals((int)this.cs.loadAll().size(), (int)3);
        this.store2.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        Assert.assertEquals((int)this.cs.loadAll().size(), (int)3);
        assert (this.cs.load((Object)"k1").getValue().equals("v1"));
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (this.cs.load((Object)"k3").getValue().equals("v3"));
        assert (this.cs.load((Object)"k4") == null);
        Set all = this.cs.loadAll();
        Assert.assertEquals((int)all.size(), (int)3);
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("k1");
        expectedKeys.add("k2");
        expectedKeys.add("k3");
        for (InternalCacheEntry a : all) {
            assert (expectedKeys.remove(a.getKey()));
        }
        assert (expectedKeys.isEmpty());
        this.cs.remove((Object)"k3");
        assert (!this.store1.containsKey("k3"));
        assert (!this.store2.containsKey("k3"));
    }

    public void testPropagatingOnePhaseCommit() throws Exception {
        int i;
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        list.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2", 6000000L)));
        list.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        list.add(new Remove((Object)"k3"));
        list.add(new Clear());
        list.add(new Store(TestInternalCacheEntryFactory.create("k4", "v4")));
        list.add(new Store(TestInternalCacheEntryFactory.create("k5", "v5", 6000000L)));
        list.add(new Store(TestInternalCacheEntryFactory.create("k6", "v6")));
        list.add(new Remove((Object)"k6"));
        GlobalTransaction t = this.gtf.newGlobalTransaction(null, false);
        this.cs.prepare(list, t, true);
        CacheStore[] allStores = new CacheStore[]{this.cs, this.store1, this.store2};
        for (i = 1; i < 7; ++i) {
            if (i < 4 || i == 6) {
                for (CacheStore s : allStores) {
                    assert (!s.containsKey((Object)("k" + i))) : "Failed on k" + i;
                }
                continue;
            }
            for (CacheStore s : allStores) {
                assert (s.containsKey((Object)("k" + i)));
                assert (s.load((Object)("k" + i)).getValue().equals("v" + i));
                assert (s.load((Object)("k" + i)).getLifespan() == (i == 5 ? 6000000L : -1L));
            }
        }
        this.cs.clear();
        for (i = 1; i < 7; ++i) {
            for (CacheStore s : allStores) {
                assert (!s.containsKey((Object)("k" + i)));
            }
        }
    }

    public void testPropagatingTwoPhaseCommit() throws Exception {
        int i;
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        list.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2", 6000000L)));
        list.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        list.add(new Remove((Object)"k3"));
        list.add(new Clear());
        list.add(new Store(TestInternalCacheEntryFactory.create("k4", "v4")));
        list.add(new Store(TestInternalCacheEntryFactory.create("k5", "v5", 6000000L)));
        list.add(new Store(TestInternalCacheEntryFactory.create("k6", "v6")));
        list.add(new Remove((Object)"k6"));
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.prepare(list, tx, false);
        CacheStore[] allStores = new CacheStore[]{this.cs, this.store1, this.store2};
        for (i = 1; i < 7; ++i) {
            for (CacheStore s : allStores) {
                assert (!s.containsKey((Object)("k" + i)));
            }
        }
        this.cs.commit(tx);
        for (i = 1; i < 7; ++i) {
            if (i < 4 || i == 6) {
                for (CacheStore s : allStores) {
                    assert (!s.containsKey((Object)("k" + i)));
                }
                continue;
            }
            for (CacheStore s : allStores) {
                assert (s.containsKey((Object)("k" + i)));
                assert (s.load((Object)("k" + i)).getValue().equals("v" + i));
                assert (s.load((Object)("k" + i)).getLifespan() == (i == 5 ? 6000000L : -1L));
            }
        }
    }

    public void testPropagatingStreams() throws IOException, CacheLoaderException {
        this.store2.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.store2.store(TestInternalCacheEntryFactory.create("k2", "v2", 6000000L));
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(byteStream);
        this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream((ObjectOutput)oos));
        oos.close();
        byteStream.close();
        this.cs.clear();
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        for (DummyInMemoryCacheStore s : this.stores) {
            assert (!s.containsKey("k1"));
            assert (!s.containsKey("k2"));
        }
        this.cs.fromStream((ObjectInput)new UnclosableObjectInputStream((ObjectInput)new ObjectInputStream(new ByteArrayInputStream(byteStream.toByteArray()))));
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.load((Object)"k1").getValue().equals("v1"));
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (this.cs.load((Object)"k1").getLifespan() == -1L);
        assert (this.cs.load((Object)"k2").getLifespan() == 6000000L);
        assert (this.store2.containsKey("k1"));
        assert (this.store2.containsKey("k2"));
        assert (this.store2.load("k1").getValue().equals("v1"));
        assert (this.store2.load("k2").getValue().equals("v2"));
        assert (this.store2.load("k1").getLifespan() == -1L);
        assert (this.store2.load("k2").getLifespan() == 6000000L);
        assert (!this.store1.containsKey("k1"));
        assert (!this.store1.containsKey("k2"));
    }

    @Override
    public void testConfigFile() {
    }
}

