/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="lock.APITest", groups={"functional"})
@CleanupAfterMethod
public class APITest
extends MultipleCacheManagersTest {
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = APITest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        cfg.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC).cacheStopTimeout(Integer.valueOf(0));
        cfg.setLockAcquisitionTimeout(100L);
        this.cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{this.cm1, this.cm2});
        this.cm1.getCache();
        this.cm2.getCache();
    }

    public void testLockSuccess() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        cache1.put((Object)"k", (Object)"v");
        this.tm(0).begin();
        assert (cache1.getAdvancedCache().lock((Object[])new String[]{"k"}));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testLockFailure() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new String[]{"k"});
        this.tm(0).rollback();
    }

    public void testSilentLockFailure() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        assert (!cache1.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock((Object[])new String[]{"k"}));
        this.tm(0).rollback();
    }

    public void testSilentLockFailureAffectsPostOperations() throws Exception {
        final Cache cache = this.cache(0);
        final TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        ExecutorService e = Executors.newCachedThreadPool();
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final CountDownLatch continueLatch = new CountDownLatch(1);
        cache.put((Object)1, (Object)"v1");
        Future<Void> f1 = e.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                tm.begin();
                try {
                    cache.put((Object)1, (Object)"v2");
                    waitLatch.countDown();
                    continueLatch.await();
                }
                catch (Exception e) {
                    tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (tm.getStatus() == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                }
                return null;
            }
        });
        Future<Void> f2 = e.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                waitLatch.await();
                tm.begin();
                try {
                    AdvancedCache silentCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
                    silentCache.put((Object)1, (Object)"v3");
                    assert (!silentCache.lock((Object[])new Integer[]{1}));
                    String object = (String)cache.get((Object)1);
                    assert ("v1".equals(object)) : "Expected v1 but got " + object;
                    cache.get((Object)1);
                }
                catch (Exception e) {
                    tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (tm.getStatus() == 0) {
                        tm.commit();
                    } else {
                        tm.rollback();
                    }
                    continueLatch.countDown();
                }
                return null;
            }
        });
        f1.get();
        f2.get();
    }

    public void testMultiLockSuccess() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(0).begin();
        assert (cache1.getAdvancedCache().lock(Arrays.asList("k1", "k2", "k3")));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testMultiLockFailure() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k3", (Object)"v2");
        this.tm(1).suspend();
        this.tm(0).begin();
        cache1.getAdvancedCache().lock(Arrays.asList("k1", "k2", "k3"));
        this.tm(0).rollback();
    }

    public void testSilentMultiLockFailure() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)"k1", (Object)"v");
        cache1.put((Object)"k2", (Object)"v");
        cache1.put((Object)"k3", (Object)"v");
        this.tm(1).begin();
        cache2.put((Object)"k3", (Object)"v2");
        Transaction t = this.tm(1).suspend();
        this.tm(0).begin();
        assert (!cache1.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock(Arrays.asList("k1", "k2", "k3")));
        this.tm(0).rollback();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockOnNonTransactionalCache() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager(false)){

            @Override
            public void call() {
                this.cm.getCache().getAdvancedCache().lock(new Object[]{"k"});
            }
        });
    }

    public void testNoLockingInterceptorWithoutConcurrentAccess() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().supportsConcurrentUpdates(false);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                AbstractLockingInterceptor locking = TestingUtil.findInterceptor(this.cm.getCache(), AbstractLockingInterceptor.class);
                Assert.assertNull((Object)locking);
            }
        });
    }
}

