/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.OptimisticTxFailureAfterLockingTest")
@CleanupAfterMethod
public class OptimisticTxFailureAfterLockingTest
extends MultipleCacheManagersTest {
    public void testInOwner() throws Exception {
        this.doTest(0, 0);
    }

    public void testInNonOwner() throws Exception {
        this.doTest(1, 0);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = OptimisticTxFailureAfterLockingTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true);
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
        builder.clustering().hash().numOwners(2);
        builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
        this.createClusteredCaches(3, builder);
    }

    private void doTest(int primaryOwnerIndex, int execIndex) throws Exception {
        MagicKey key = new MagicKey(this.cache(primaryOwnerIndex), this.cache(2));
        this.cache(primaryOwnerIndex).put((Object)key, (Object)"v1");
        this.tm(execIndex).begin();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(execIndex).get((Object)key));
        Transaction transaction = this.tm(execIndex).suspend();
        this.cache(primaryOwnerIndex).put((Object)key, (Object)"v2");
        this.tm(execIndex).resume(transaction);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache(execIndex).put((Object)key, (Object)"v3"));
        try {
            this.tm(execIndex).commit();
            AssertJUnit.fail((String)"Exception expected!");
        }
        catch (RollbackException e) {
            // empty catch block
        }
        this.assertNoTransactions();
        this.assertNotLocked(this.cache(primaryOwnerIndex), (Object)key);
    }
}

